// This is a simple simulator for the Arbadell computer
// This file will handle all of the GUI operations
// Written by: Shane Avery

import javax.swing.*;
import java.awt.*;
import java.lang.Object;
import java.awt.event.*;
import javax.swing.event.*;
import java.io.*;

// This is the main public class and it will set up the GUI
public class Arbadell
{
	public static void main(String[] args)
	{
		ArbFrame frame = new ArbFrame();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.show();
	}
}

// This is the frame info for the GUI
class ArbFrame extends JFrame
{
	public ArbFrame()
	{
		setTitle("Arbadell Simulator");
		setSize(WIDTH,HEIGHT);

		Simulator ArbSim = new Simulator();

		// Here is the panel for all the Strings
		ArbPanel panel = new ArbPanel(ArbSim);
		Container contentPane = getContentPane();
		contentPane.add(panel);

		// Here is the panel for the buttons on the bottom
		ButtonsBottom buttonPanelBottom = new ButtonsBottom(ArbSim, panel);
		Container contentPaneButtonsBottom = getContentPane();
		contentPaneButtonsBottom.add(buttonPanelBottom, "South");

		// Here is the panel for the buttons on the top
		ButtonsTop buttonPanelTop = new ButtonsTop(ArbSim, panel);
		Container contentPaneButtonsTop = getContentPane();
		contentPaneButtonsTop.add(buttonPanelTop, "North");

		// Here is the code to generate menus
		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);

		JMenu fileMenu = new JMenu("File");
		menuBar.add(fileMenu);
		JMenuItem openItem = new JMenuItem("Open");
		fileMenu.add(openItem);
		JMenuItem exitItem = new JMenuItem("Exit");
		fileMenu.add(exitItem);

		// This will assign listeners to the menu items
		SystemExit MenuExit = new SystemExit();
		exitItem.addActionListener(MenuExit);

		SystemOpen MenuOpen = new SystemOpen(this, ArbSim, panel);
		openItem.addActionListener(MenuOpen);
	}

	public static final int WIDTH = 1000;
	public static final int HEIGHT = 450;
}

// This is the listener for open in the menu
class SystemOpen implements ActionListener
{
	public SystemOpen(ArbFrame FrameIn, Simulator ArbSimIn, ArbPanel panelIn)
	{
		FrameArguement=FrameIn;
		ArbSim=ArbSimIn;
		panel=panelIn;
	}

	public void actionPerformed(ActionEvent Event)
	{
		JFileChooser chooser = new JFileChooser();
		chooser.setCurrentDirectory(new File("."));
		chooser.showOpenDialog(FrameArguement);
		String ArbFile = chooser.getSelectedFile().getPath();

		// We must do this because the opening of a file may cause an exception
		// that would need to be caught
		try
		{
			FileInputStream ArbFileInput = new FileInputStream(ArbFile);
			ArbSim.NewFile(ArbFileInput);
			panel.RepaintIt();

		}

		// If an execption occurs
		catch(Exception e)
		{
			e.printStackTrace();
			System.exit(0);
		}
	}

	private ArbFrame FrameArguement;
	private Simulator ArbSim;
	private ArbPanel panel;
}

// This is the listener for exit in the menu
class SystemExit implements ActionListener
{
	public void actionPerformed(ActionEvent Event)
	{
		System.exit(0);
	}
}

// This class will define the buttons and text fields on the
// top the screen
class ButtonsTop extends JPanel
{
	public ButtonsTop(Simulator ArbSimIn, ArbPanel panelIn)
	{
		ArbSim=ArbSimIn;
		panel=panelIn;

		// Here we will add the top buttons on the panel
		JButton PC = new JButton("PC");
		JButton W = new JButton("W");
		JButton Memory = new JButton("Edit Memory");
		JTextField PCText = new JTextField("0", 4);
		JTextField WText = new JTextField("0", 2);
		JTextField MemAdd = new JTextField("0", 4);
		JTextField MemValue = new JTextField("0", 2);
		JLabel MemValueLabel = new JLabel("Value: ");
		JLabel MemAddLabel = new JLabel("Address: ");
		JLabel blank1 = new JLabel("        ");
		JLabel blank2 = new JLabel("        ");
		JLabel blank3 = new JLabel("        ");
		JButton SetInt0Button = new JButton("Set int0");
		JButton SetInt1Button = new JButton("Set int1");

		add(SetInt0Button);
		add(SetInt1Button);
		add(blank3);
		add(PC);
		add(PCText);
		add(blank1);
		add(W);
		add(WText);
		add(blank2);
		add(Memory);
		add(MemAddLabel);
		add(MemAdd);
		add(MemValueLabel);
		add(MemValue);

		PCButtonAction PCButton = new PCButtonAction(ArbSim, panel, PCText);
		PC.addActionListener(PCButton);

		WButtonAction WButton = new WButtonAction(ArbSim, panel, WText);
		W.addActionListener(WButton);

		MemButtonAction MemButton = new MemButtonAction(ArbSim, panel, MemAdd, MemValue);
		Memory.addActionListener(MemButton);

		SetInt0ButtonAction Int0Button = new SetInt0ButtonAction(ArbSim, panel);
		SetInt0Button.addActionListener(Int0Button);

		SetInt1ButtonAction Int1Button = new SetInt1ButtonAction(ArbSim, panel);
		SetInt1Button.addActionListener(Int1Button);

	}

	private Simulator ArbSim = new Simulator();
	private ArbPanel panel = new ArbPanel();
}

// This class will define the action for when the Set Int0 button is pushed
class SetInt0ButtonAction implements ActionListener
{
	public SetInt0ButtonAction(Simulator ArbSimIn, ArbPanel panelIn)
	{
		ArbSim=ArbSimIn;
		panel=panelIn;
	}

	public void actionPerformed(ActionEvent event)
	{
		ArbSim.setInt0();
		panel.RepaintIt();
	}

	private Simulator ArbSim = new Simulator();
	private ArbPanel panel = new ArbPanel();
}

// This class will define the action for when the Set Int1 button is pushed
class SetInt1ButtonAction implements ActionListener
{
	public SetInt1ButtonAction(Simulator ArbSimIn, ArbPanel panelIn)
	{
		ArbSim=ArbSimIn;
		panel=panelIn;
	}

	public void actionPerformed(ActionEvent event)
	{
		ArbSim.setInt1();
		panel.RepaintIt();
	}

	private Simulator ArbSim = new Simulator();
	private ArbPanel panel = new ArbPanel();
}

// This class will define the action for when the PC button is pushed
class PCButtonAction implements ActionListener
{
	public PCButtonAction(Simulator ArbSimIn, ArbPanel panelIn, JTextField PCTextIn)
	{
		ArbSim=ArbSimIn;
		panel=panelIn;
		PCText=PCTextIn;
	}

	public void actionPerformed(ActionEvent event)
	{
		String hex = PCText.getText().trim();
		ArbSim.setPC(Convert.toint(hex));
		panel.RepaintIt();
	}

	private Simulator ArbSim = new Simulator();
	private ArbPanel panel = new ArbPanel();
	private JTextField PCText = new JTextField(4);
}

// This class will define the action for when the W button is pushed
class WButtonAction implements ActionListener
{
	public WButtonAction(Simulator ArbSimIn, ArbPanel panelIn, JTextField WTextIn)
	{
		ArbSim=ArbSimIn;
		panel=panelIn;
		WText=WTextIn;
	}

	public void actionPerformed(ActionEvent event)
	{
		String hex = WText.getText().trim();
		ArbSim.setW((char)Convert.toint(hex));
		panel.RepaintIt();
	}

	private Simulator ArbSim = new Simulator();
	private ArbPanel panel = new ArbPanel();
	private JTextField WText = new JTextField(2);
}

// This class will define the action for when the Memory button is pushed
class MemButtonAction implements ActionListener
{
	public MemButtonAction(Simulator ArbSimIn, ArbPanel panelIn, JTextField MemAddIn, JTextField MemValueIn)
	{
			ArbSim=ArbSimIn;
			panel=panelIn;
			MemAdd=MemAddIn;
			MemValue=MemValueIn;
	}

	public void actionPerformed(ActionEvent event)
	{
		String add = MemAdd.getText().trim();
		String val = MemValue.getText().trim();
		ArbSim.setMem(Convert.toint(add),(char)Convert.toint(val));
		panel.RepaintIt();
	}

	private Simulator ArbSim = new Simulator();
	private ArbPanel panel = new ArbPanel();
	private JTextField MemAdd = new JTextField(4);
	private JTextField MemValue = new JTextField(2);
}

// This class will define the buttons and text fields on the
// bottom the screen
class ButtonsBottom extends JPanel
{
	public ButtonsBottom(Simulator ArbSimIn, ArbPanel panelIn)
	{
		ArbSim=ArbSimIn;
		panel=panelIn;

		// Here we will add the bottom buttons on the panel
		JButton step = new JButton("Step");
		JButton executeUntil = new JButton("Execute Until");
		JTextField until = new JTextField("0", 4);
		JButton reset = new JButton("Reset");
		add(step);
		add(executeUntil);
		add(until);
		add(reset);

		ResetButtonAction ResetButton = new ResetButtonAction(ArbSim, panel);
		reset.addActionListener(ResetButton);

		StepButtonAction StepButton = new StepButtonAction(ArbSim, panel);
		step.addActionListener(StepButton);

		StepUntilButtonAction StepUntilButton = new StepUntilButtonAction(ArbSim, panel, until);
		executeUntil.addActionListener(StepUntilButton);
	}

	private Simulator ArbSim = new Simulator();
	private ArbPanel panel = new ArbPanel();
}

// This class will define the action for the Execute until button
class StepUntilButtonAction implements ActionListener
{
	public StepUntilButtonAction(Simulator ArbSimIn, ArbPanel panelIn, JTextField untilIn)
	{
		ArbSim=ArbSimIn;
		panel=panelIn;
		until=untilIn;
	}

	public void actionPerformed(ActionEvent event)
	{
		String untilMemString = until.getText().trim();
		int untilMem = Convert.toint(untilMemString);
		while(untilMem != ArbSim.getPC())
		{
			String value=panel.getValue();
			ArbSim.step(value);
			panel.RepaintIt();
		}
	}

	private Simulator ArbSim = new Simulator();
	private ArbPanel panel = new ArbPanel();
	private JTextField until = new JTextField();
}

// This class will define the action for the Reset button
class ResetButtonAction implements ActionListener
{
	public ResetButtonAction(Simulator ArbSimIn, ArbPanel panelIn)
	{
		ArbSim=ArbSimIn;
		panel=panelIn;
	}

	public void actionPerformed(ActionEvent event)
	{
		ArbSim.reset();
		panel.RepaintIt();
	}

	private Simulator ArbSim = new Simulator();
	private ArbPanel panel = new ArbPanel();
}

// This class will define the action for the Step button
class StepButtonAction implements ActionListener
{
	public StepButtonAction(Simulator ArbSimIn, ArbPanel panelIn)
	{
		ArbSim=ArbSimIn;
		panel=panelIn;
	}

	public void actionPerformed(ActionEvent event)
	{
		String value=panel.getValue();
		ArbSim.step(value);
		panel.RepaintIt();
	}

	private Simulator ArbSim = new Simulator();
	private ArbPanel panel = new ArbPanel();
}

// This is the panel on which most of the interesting GUI stuff takes place
class ArbPanel extends JPanel
{
	public ArbPanel()
	{
		// NULL
	}
	public ArbPanel(Simulator ArbSimIn)
	{
		JButton MemBeginJButton = new JButton("Memory starting value: ");
		JLabel Space = new JLabel("                                                                                                ");
		JLabel Space2 = new JLabel("                 ");
		JTextField address = new JTextField("0", 4);
		JLabel IoRecv = new JLabel("iorecv value:  ");
		value = new JTextField("0", 2);
		JButton PageUpJButton = new JButton("Up");
		JButton PageDownJButton = new JButton("Down");
		add(IoRecv);
		add(value);
		add(Space2);
		add(MemBeginJButton);
		add(address);
		add(PageUpJButton);
		add(PageDownJButton);
		add(Space);
		ArbSim=ArbSimIn;

		MemBeginButtonAction MemBeginButton = new MemBeginButtonAction(ArbSim, this, address);
		MemBeginJButton.addActionListener(MemBeginButton);

		PageDownButtonAction PageDownButton = new PageDownButtonAction(ArbSim, this);
		PageDownJButton.addActionListener(PageDownButton);

		PageUpButtonAction PageUpButton = new PageUpButtonAction(ArbSim, this);
		PageUpJButton.addActionListener(PageUpButton);

	}

	// This is a function needed to repaint the panel as needed
	public void RepaintIt()
	{
		repaint();
	}

	public void paintComponent(Graphics g)
	{
		//Simulator ArbSim = new Simulator();
		super.paintComponent(g);

		// Output the values of the registers
		g.drawString("Registers", 0, 30);
		g.drawString("PC = " + Convert.tohex(ArbSim.getPC()), 0, 45);
		g.drawString("W  = " + Convert.tohex(ArbSim.getW()), 0, 60);
		//g.drawString("SR = " + Convert.tohex(ArbSim.getSR()), 30, 75);
		g.drawString("SR => " + "Z=" + ArbSim.getZ() + " ie0=" + ArbSim.getie0() +
					 " ie1=" + ArbSim.getie1(), 0, 75);

		// Output the stack
		g.drawString("Stack", 0, 100);
		for(int i=0; i<11; i++)
			g.drawString("" + Convert.tohex(ArbSim.getArbStack(i)), 0, 115+(15*i));

		// Output the status of the interrupts
		String set0,set1;
		int int0=ArbSim.getInt0();
		int int1=ArbSim.getInt1();

		if(int0 == 0)
			set0 = " not set";
		else
			set0 = " set";

		if(int1 == 0)
			set1 = " not set";
		else
			set1 = " set";

		g.drawString("Interrupt Status:", 40, 100);
		g.drawString("Int0 is" + set0, 40, 115);
		g.drawString("Int1 is" + set1, 40, 130);

		// Output the memory addresses
		for(int i=0; i<16; i++)
			g.drawString("" + Convert.tohex((ArbSim.getMemDisplayStart() + 16*i)), 150, 45+(15*i));

		int counter=0;
		// Output the memory
		for(int i=0; i<16; i++)
		{
			for(int j=0; j<16; j++)
			{
				g.drawString(" " + Convert.tohex(ArbSim.getMem(ArbSim.getMemDisplayStart()+counter)), 200+(j*30), 45+(i*15));
				counter++;
			}
		}

		// Output the assembly code
		g.drawString(">>>", 715, 45);
		int index=ArbSim.getPC();
		for(int i=0; i<16; i++)
		{
			if(ArbSim.NumberOfArguements(ArbSim.getMem(index))==0)
			{
				g.drawString("" + ArbSim.decode(ArbSim.getMem(index)), 750, 45+(i*15));
				if(index==0xffff)
					index=0;
				else
					index++;
			}
			else if(ArbSim.NumberOfArguements(ArbSim.getMem(index))==1)
			{
				g.drawString("" + ArbSim.decode(ArbSim.getMem(index)), 750, 45+(i*15));
				if(index==0xffff)
					index=0;
				else
					index++;

				g.drawString("" + Convert.tohex(ArbSim.getMem(index)), 825, 45+(i*15));
				if(index==0xffff)
					index=0;
				else
					index++;
			}
			else
			{
				g.drawString("" + ArbSim.decode(ArbSim.getMem(index)), 750, 45+(i*15));
				if(index==0xffff)
					index=0;
				else
					index++;

				g.drawString("" + Convert.tohex(ArbSim.getMem(index)), 825, 45+(i*15));
				if(index==0xffff)
					index=0;
				else
					index++;

				g.drawString("" + Convert.tohex(ArbSim.getMem(index)), 840, 45+(i*15));
				if(index==0xffff)
					index=0;
				else
					index++;
			}
		}
	}

	public String getValue()
	{
		String valueTrim = value.getText().trim();
		return valueTrim;
	}

	private Simulator ArbSim = new Simulator();
	private JTextField value;
}

// This class will define the action for the Memory Starting Value button
class MemBeginButtonAction implements ActionListener
{
	MemBeginButtonAction(Simulator ArbSimIn, ArbPanel panelIn, JTextField MemBeginIn)
	{
		ArbSim=ArbSimIn;
		panel=panelIn;
		MemBegin=MemBeginIn;
	}

	public void actionPerformed(ActionEvent event)
	{
		String add = MemBegin.getText().trim();
		ArbSim.setMemDisplayStart(Convert.toint(add));
		panel.RepaintIt();
	}

	private Simulator ArbSim = new Simulator();
	private ArbPanel panel = new ArbPanel();
	private JTextField MemBegin = new JTextField();
}

// This class will define the action for the Down button
class PageDownButtonAction implements ActionListener
{
	PageDownButtonAction(Simulator ArbSimIn, ArbPanel panelIn)
	{
		ArbSim=ArbSimIn;
		panel=panelIn;
	}

	public void actionPerformed(ActionEvent event)
	{

		int value = ArbSim.getMemDisplayStart();
		if(value < 0xfff1)
			value = value+0x10;
		ArbSim.setMemDisplayStart(value);
		panel.RepaintIt();
	}

	private Simulator ArbSim = new Simulator();
	private ArbPanel panel = new ArbPanel();
}

// This class will define the action for the Up button
class PageUpButtonAction implements ActionListener
{
	PageUpButtonAction(Simulator ArbSimIn, ArbPanel panelIn)
	{
		ArbSim=ArbSimIn;
		panel=panelIn;
	}

	public void actionPerformed(ActionEvent event)
	{

		int value = ArbSim.getMemDisplayStart();
		if(value > 0x0a)
			value = value-0x10;
		ArbSim.setMemDisplayStart(value);
		panel.RepaintIt();
	}

	private Simulator ArbSim = new Simulator();
	private ArbPanel panel = new ArbPanel();
}