// This is the file that will perform most of the actions of the simulator
import java.io.*;
public class Simulator
{
	// Here is the constructor to initialize the variables
	public Simulator()
	{
		PC=0;
		W=0;
		Z='0';ie0='0';ie1='0';
		int0=0;int1=0;
		interrupt=0;
		StackIndex=0;
		for(int i=0;i<131072;i++)
			Mem[i]=0;
		for(int j=0;j<11;j++)
			ArbStack[j]=0;

		MemDisplayStart=0;
	}

	// The following are functions to return the values of the private variables
	public int getPC()
	{
		return PC;
	}

	public char getW()
	{
		return W;
	}

	public char getMem(int i)
	{
		return Mem[i];
	}

	public int getArbStack(int i)
	{
		return ArbStack[i];
	}

	public int getMemDisplayStart()
	{
		return MemDisplayStart;
	}

	public char getZ()
	{
		return Z;
	}

	public char getie0()
	{
		return ie0;
	}

	public char getie1()
	{
		return ie1;
	}

	public int getInt0()
	{
		return int0;
	}

	public int getInt1()
	{
		return int1;
	}

	// This is a function to increment the program counter
	public void incrementPC()
	{
		PC=PC++;
	}

	// The following are functions to set the values of the private variables
	public void setPC(int newPCvalue)
	{
		PC=newPCvalue;
	}

	public void setW(char newWvalue)
	{
		W=newWvalue;
	}

	public void setMem(int index, char value)
	{
		Mem[index]=value;
	}

	public void setMemDisplayStart(int value)
	{
		MemDisplayStart=value;
	}

	public void setInt0()
	{
		int0=1;
	}

	public void setInt1()
	{
		int1=1;
	}

	// These will clear the interrupts
	public void clearInt0()
	{
		int0=0;
	}

	public void clearInt1()
	{
		int1=0;
	}

	// Here is a function to push an address on the stack
	public void pushStack(int value)
	{
		ArbStack[StackIndex]=value;
		StackIndex++;
	}

	// Here is a function to pop an address on the stack
	public int popStack()
	{
		int value = ArbStack[StackIndex-1];
		ArbStack[StackIndex-1]=0;
		StackIndex--;
		return value;
	}

	// This function will convert the Hex character to the string equivalent
	public String decode(char HexInstruction)
	{
		String StringInstruction;
		if(HexInstruction==0)
			StringInstruction="movel    ";
		else if(HexInstruction==1)
			StringInstruction="movem    ";
		else if(HexInstruction==2)
			StringInstruction="moves    ";
		else if(HexInstruction==3)
			StringInstruction="inv      ";
		else if(HexInstruction==4)
			StringInstruction="inc      ";
		else if(HexInstruction==5)
			StringInstruction="dec      ";
		else if(HexInstruction==6)
			StringInstruction="shiftr   ";
		else if(HexInstruction==7)
			StringInstruction="shiftl   ";
		else if(HexInstruction==8)
			StringInstruction="addl     ";
		else if(HexInstruction==9)
			StringInstruction="andl     ";
		else if(HexInstruction==10)
			StringInstruction="orl      ";
		else if(HexInstruction==11)
			StringInstruction="addm     ";
		else if(HexInstruction==12)
			StringInstruction="andm     ";
		else if(HexInstruction==13)
			StringInstruction="orm      ";
		else if(HexInstruction==14)
			StringInstruction="call     ";
		else if(HexInstruction==15)
			StringInstruction="bra      ";
		else if(HexInstruction==16)
			StringInstruction="braz     ";
		else if(HexInstruction==17)
			StringInstruction="ret      ";
		else if(HexInstruction==18)
			StringInstruction="reti     ";
		else if(HexInstruction==19)
			StringInstruction="iorecv   ";
		else if(HexInstruction==20)
			StringInstruction="iosend   ";
		else if(HexInstruction==21)
			StringInstruction="setie    ";
		else if(HexInstruction==22)
			StringInstruction="ti0      ";
		else if(HexInstruction==23)
			StringInstruction="ti1      ";
		else
			StringInstruction="error    ";

		return StringInstruction;
	}

	// This function will return the number of arguements for an instruction
	public int NumberOfArguements(char instruction)
	{
		int arguements=0;
		if(instruction==0 || instruction==8 ||  instruction==9 || instruction==10 || instruction==21)
			arguements=1;
		else if(instruction==1  || instruction==11 || instruction==12 || instruction==13 ||
				instruction==14 || instruction==15 || instruction==16 || instruction==17 ||
				instruction==19 || instruction==20 || instruction==22 || instruction==23 ||
				instruction==2)
			arguements=2;
		else
			arguements=0;
		return arguements;
	}

	// This function will take the newly opened file and dump the contents to the Mem array
	public void NewFile(FileInputStream ArbFile)
	{
		String address = "";
		try
		{
			char ch4 = 0;
			char ch5,data;

			// This first read is just to grab the first semicolon
			char grab=(char)ArbFile.read();

			while(ch4 != ';')
			{
				// Get the address
				char ch0=(char)ArbFile.read();
				char ch1=(char)ArbFile.read();
				if(ch1 == ' ')
				{
					address = "" + "0" + "0" + "0" + ch0;
				}
				else
				{
					char ch2=(char)ArbFile.read();
					if(ch2 == ' ')
					{
						address = "" + "0" + "0" + ch0 + ch1;
					}
					else
					{
						char ch3=(char)ArbFile.read();
						if(ch3 == ' ')
						{
							address = "" + "0" + ch0 + ch1 + ch2;
						}
						else
						{
							// If we haven't reached the space yet then we need to grab it
							char grab2=(char)ArbFile.read();
							address = "" + ch0 + ch1 + ch2 + ch3;
						}
					}
				}

				// Now that the address is read as a String convert it
				int index = Convert.toint(address);

				while(true)
				{
					// Grab the next byte convert to a char
					ch4=(char)ArbFile.read();
					if(ch4 == ':' || ch4 == ';')
						break;

					ch5=(char)ArbFile.read();
					data = Convert.charToChar(ch4, ch5);

					// Write this new data value into the index value and increment index
					setMem(index, data);
					index++;
				}
			}
		}
		catch(Exception e)
		{
			System.exit(0);
		}

	}

	// This function will reset the CPU
	public void reset()
	{
		W=0;
		PC=0;
		Z='0';
		ie0='0';
		ie1='0';
		StackIndex=0;
		for(int i=0;i<11;i++)
			ArbStack[i]=0;
	}

	// This function will step an instruction
	public void step(String iorecvString)
	{
		char inst = Mem[PC];
		char iorecv = (char)Convert.toint(iorecvString);

		// First check for an interrupt
		if(int0 == 1 && ie0 == '1' && interrupt == 0)
		{
			pushStack(PC);
			PC=0xfff0;
			interrupt = 1;
		}
		else if(int1 == 1 && ie1 == '1' && interrupt == 0)
		{
			pushStack(PC);
			PC=0xfff8;
			interrupt = 1;
		}

		// If there is no interrupt then determine which instruction and execute it
		else
		{
			if(inst == 0)
			{
				W=Mem[PC+1];
				PC=PC+2;
			}
			if(inst == 1)
			{
				int MemAdd = Convert.charsToInt(Mem[PC+1], Mem[PC+2]);
				W=Mem[MemAdd];
				PC=PC+3;
			}
			if(inst == 2)
			{
				int MemAdd = Convert.charsToInt(Mem[PC+1], Mem[PC+2]);
				Mem[MemAdd]=W;
				PC=PC+3;
			}
			if(inst == 3)
			{
				W=(char)~W;
				PC++;
			}
			if(inst == 4)
			{
				W++;
				PC++;
			}
			if(inst == 5)
			{
				W--;
				PC++;
			}
			if(inst == 6)
			{
				int number=0;
				number=(int)W;
				number=number&0x00ff;
				number=number>>1;
				W=(char)number;
				PC++;
			}
			if(inst == 7)
			{
				int number=0;
				number=(int)W;
				number=number&0x00ff;
				number=number<<1;
				W=(char)number;
				PC++;
			}
			if(inst == 8)
			{
				int number = (int)W;
				number=number&0x00ff;
				int literal = Mem[PC+1];
				number=number+literal;
				W=(char)number;
				PC=PC+2;
			}
			if(inst == 9)
			{
				int number = (int)W;
				number=number&0x00ff;
				int literal = Mem[PC+1];
				number=number&literal;
				W=(char)number;
				PC=PC+2;
			}
			if(inst == 10)
			{
				int number = (int)W;
				number=number&0x00ff;
				int literal = Mem[PC+1];
				number=number|literal;
				W=(char)number;
				PC=PC+2;
			}
			if(inst == 11)
			{
				int MemAdd = Convert.charsToInt(Mem[PC+1], Mem[PC+2]);
				int number = (int)W;
				number=number&0x00ff;
				number=number+Mem[MemAdd];
				W=(char)number;
				PC=PC+3;
			}
			if(inst == 12)
			{
				int MemAdd = Convert.charsToInt(Mem[PC+1], Mem[PC+2]);
				int number = (int)W;
				number=number&0x00ff;
				number=number&Mem[MemAdd];
				W=(char)number;
				PC=PC+3;
			}
			if(inst == 13)
			{
				int MemAdd = Convert.charsToInt(Mem[PC+1], Mem[PC+2]);
				int number = (int)W;
				number=number&0x00ff;
				number=number|Mem[MemAdd];
				W=(char)number;
				PC=PC+3;
			}
			if(inst == 14)
			{
				int MemAdd = Convert.charsToInt(Mem[PC+1], Mem[PC+2]);
				pushStack(PC);
				PC=MemAdd;
			}
			if(inst == 15)
			{
				int MemAdd = Convert.charsToInt(Mem[PC+1], Mem[PC+2]);
				PC=MemAdd;
			}
			if(inst == 16)
			{
				int MemAdd = Convert.charsToInt(Mem[PC+1], Mem[PC+2]);
				if(Z == '1')
				PC=MemAdd;
			}
			if(inst == 17)
			{
				PC = popStack();
				PC = PC+3;
			}
			if(inst == 18)
			{
				PC = popStack();
				if(int0 == 1)
					int0=0;
				else
					int1=0;

				interrupt=0;
			}
			if(inst == 19)
			{
				W=iorecv;
				PC=PC+3;
			}
			if(inst == 20)
			{
				PC=PC+3;
			}
			if(inst == 21)
			{
				char literal = Mem[PC+1];
				if(literal == 1)
					ie0='1';
				if(literal == 2)
					ie1='1';
				if(literal == 3)
				{
					ie1='1';ie0='1';
				}
				PC=PC+2;
			}
			if(inst == 22)
			{
				if(int0 == 1)
				{
					int MemAdd = Convert.charsToInt(Mem[PC+1], Mem[PC+2]);
					PC=MemAdd;
				}
				else
				{
					PC=PC+3;
				}
			}
			if(inst == 23)
			{
				if(int1 == 1)
				{
					int MemAdd = Convert.charsToInt(Mem[PC+1], Mem[PC+2]);
					PC=MemAdd;
				}
				else
				{
					PC=PC+3;
				}
			}

			// Set the zero bit in the SR if W register is zero
			if(W == 0)
			{
				Z = '1';
			}
			else
			{
				Z = '0';
			}
		}
	}

	// These are the private variables
	private int PC;							//program counter
	private char W;							//w or working register
	private char Z,ie0,ie1;						//status register
	private char[] Mem = new char[131072];	//Memory (16 bit address bus)
	private int[] ArbStack = new int[11];	//Stack
	private int StackIndex;

	private int MemDisplayStart;
	private int int0,int1;
	private int interrupt;
}