// This file is reponsible for converting integers,
// characters, and Strings, to intergers, characters, and Strings
public class Convert
{
	// This function will convert the integer to a String which
	// will be the hex value of the integer
	public static String tohex(int n)
	{
		String hex;
		String w,x,y,z;
		int temp;

		temp = 0xf000 & n;
		temp = temp >> 12;
		w = nibToHex(temp);

		temp = 0x0f00 & n;
		temp = temp >> 8;
		x = nibToHex(temp);

		temp = 0x00f0 & n;
		temp = temp >> 4;
		y = nibToHex(temp);

		temp = 0x000f & n;
		z = nibToHex(temp);

		hex = "" + w + x + y + z;

		return hex;
	}

	// This function will return a string given a nibble that will
	// be the hex equivalent of the nibble
	public static String nibToHex(int n)
	{
		String hex = "0";
		if(n < 10)
			hex = "" + n;

		if(n == 10)
			hex = "a";
		if(n == 11)
			hex = "b";
		if(n == 12)
			hex = "c";
		if(n == 13)
			hex = "d";
		if(n == 14)
			hex = "e";
		if(n == 15)
			hex = "f";

		return hex;
	}

	// This function will convert a character to a String that is
	// the hex representation of the character
	public static String tohex(char c)
	{
		String hex;
		String y,z;
		int temp;

		temp = 0xf0 & c;
		temp = temp >> 4;
		y = nibToHex(temp);

		temp = 0x0f & c;
		z = nibToHex(temp);

		hex = "" + y + z;

		return hex;
	}

	// This function will take in a String and convert it to an integer
	public static int toint(String hexIn)
	{
		int ret=0;
		int length = hexIn.length();
		String hex = hexIn.toLowerCase();

		if (length == 2)
			ret = toint2(hex);
		else if (length == 4)
			ret = toint4(hex);

		return ret;
	}

	public static int toint2(String hex)
	{
		int ret=0;
		char temp;
		int n;

		temp = hex.charAt(0);
		n=charToInt(temp);
		ret = 16 * n;

		temp = hex.charAt(1);
		n=charToInt(temp);
		ret = ret+n;

		return ret;
	}

	public static int toint4(String hex)
	{
		int ret=0;
		char temp;
		int n;

		temp = hex.charAt(0);
		n=charToInt(temp);
		ret = 4096 * n;

		temp = hex.charAt(1);
		n=charToInt(temp);
		ret = ret + (256 * n);

		temp = hex.charAt(2);
		n=charToInt(temp);
		ret = ret + (16 * n);

		temp = hex.charAt(3);
		n=charToInt(temp);
		ret = ret + n;

		return ret;
	}

	// This will convert a character to an integer
	public static int charToInt(char c)
	{
		int ret=0;

		if(c == '0')
			ret=0;
		else if(c == '1')
			ret=1;
		else if(c == '2')
			ret=2;
		else if(c == '3')
			ret=3;
		else if(c == '4')
			ret=4;
		else if(c == '5')
			ret=5;
		else if(c == '6')
			ret=6;
		else if(c == '7')
			ret=7;
		else if(c == '8')
			ret=8;
		else if(c == '9')
			ret=9;
		else if(c == 'a')
			ret=10;
		else if(c == 'b')
			ret=11;
		else if(c == 'c')
			ret=12;
		else if(c == 'd')
			ret=13;
		else if(c == 'e')
			ret=14;
		else if(c == 'f')
			ret=15;

		return ret;
	}

	// This function will take in two chars and make them one
	public static char charToChar(char ch0, char ch1)
	{
		int number=0;
		if(ch0=='f')
			number=16*15;
		if(ch0=='e')
			number=16*14;
		if(ch0=='d')
			number=16*13;
		if(ch0=='c')
			number=16*12;
		if(ch0=='b')
			number=16*11;
		if(ch0=='a')
			number=16*10;
		if(ch0=='9')
			number=16*9;
		if(ch0=='8')
			number=16*8;
		if(ch0=='7')
			number=16*7;
		if(ch0=='6')
			number=16*6;
		if(ch0=='5')
			number=16*5;
		if(ch0=='4')
			number=16*4;
		if(ch0=='3')
			number=16*3;
		if(ch0=='2')
			number=16*2;
		if(ch0=='1')
			number=16*1;
		if(ch1=='f')
			number=number+15;
		if(ch1=='e')
			number=number+14;
		if(ch1=='d')
			number=number+13;
		if(ch1=='c')
			number=number+12;
		if(ch1=='b')
			number=number+11;
		if(ch1=='a')
			number=number+10;
		if(ch1=='9')
			number=number+9;
		if(ch1=='8')
			number=number+8;
		if(ch1=='7')
			number=number+7;
		if(ch1=='6')
			number=number+6;
		if(ch1=='5')
			number=number+5;
		if(ch1=='4')
			number=number+4;
		if(ch1=='3')
			number=number+3;
		if(ch1=='2')
			number=number+2;
		if(ch1=='1')
			number=number+1;

		return (char)number;
	}

	// This function will take in two characters and convert them to an integer
	public static int charsToInt(char ch0, char ch1)
	{
		int number=0;
		number=(int)ch0;
		number=number<<8;
		number=number+(int)ch1;
		return number;
	}

}
