/*****************************************************************/
/* Filename: Video.v						 */
/* This module is meant for the Xilinx 95108 CPLD. It is meant   */
/* run at 25MHz. It will read a byte from SRAM and display the   */
/* value to a standard VGA monitor at 640x480 resolution         */
/* Written by: Shane Avery                                       */
/* Date: December 29, 2002                                       */
/*****************************************************************/
module video(data,addressout,vidout,clk,rst,vsync,hsync,writeok,clearing);
input  [7:0]  data;
output [15:0] addressout;
input  clk,rst;
input  clearing;
output [2:0] vidout;
output vsync,hsync;
output writeok;

reg    [15:0] address;
reg    [4:0] state;
reg    [7:0] sreg1,sreg2;
reg    [5:0] counter;
reg    [9:0] counter3;
reg    [6:0] counter2;

reg    [9:0] hsyncreg;
reg    [20:0] vsyncreg;
reg    hsyncstate;
reg    vsyncstate;
reg    hsync,vsync;
reg    addroe;
reg    writeok;
reg    vid;

assign addressout = (addroe && ~clearing) ? address : 16'hzzzz;
assign vidout = (clearing) ? 3'b000 : {vid,vid,vid};

// This portion will output the vsyncs
always@(negedge rst or posedge clk) begin
	if(rst==0) begin
		vsyncreg<=0;vsync<=0;vsyncstate<=0;
	end
	else begin
		case(vsyncstate)
			0: begin
				vsyncreg<=vsyncreg+1;
				if(vsyncreg==1587) begin
					vsyncreg<=0;vsyncstate<=1;vsync<=1;
				end
			end
			
			1: begin
				vsyncreg<=vsyncreg+1;
				if(vsyncreg==417643) begin
					vsyncreg<=0;vsyncstate<=0;vsync<=0;
				end
			end
		endcase	
	end	
end

// This will output the hsyncs
always@(negedge rst or posedge clk) begin
	if(rst==0) begin
		hsyncreg<=0;hsync<=0;hsyncstate<=0;
	end
	else begin
		case(hsyncstate)
			0: begin
				hsyncreg<=hsyncreg+1;
				if(hsyncreg==93) begin
					hsyncreg<=0;hsyncstate<=1;hsync<=1;
				end
			end
			
			1: begin
				hsyncreg<=hsyncreg+1;
				if(hsyncreg==699) begin
					hsyncreg<=0;hsyncstate<=0;hsync<=0;
				end
			end
		endcase	
	end	
end

//This will increment an address counter and read a byte from RAM
//It will then shift the RAM value out to the VGA outputs
always@(negedge rst or posedge clk) begin
	if(rst==0) begin
		vid<=0;address<=0;state<=0;sreg1<=0;sreg2<=0;counter<=0;
		counter2<=0;addroe<=0;counter3<=16;writeok<=1;
	end
	else begin
		case(state)
			0: begin
				if(hsync==1) begin
					state<=19;vid<=0;
				end
			end
			
			//Counter3 is used to help determine when vertical blanking.
			//Writeok is a signal to the PIC ucontroller that 
			//it is ok to write to RAM now  			
			19: begin
				counter3<=counter3+1;
				if(counter3>47) begin
					state<=1;writeok<=0;
					if(counter3==527) begin
						counter3<=0;
					end
				end
				else
					state<=20;
			end

			20: begin
				if(hsync==0)
					state<=0;writeok<=1;
			end

			//Counter2 is used for horizontal blanking.
			//Addroe is used to tristate the address output
			//to allow the PIC to write to RAM
			1: begin
				counter2<=counter2+1;addroe<=1;sreg1<=data;
				if(counter2==47) begin
					state<=2;counter2<=0;
				end
			end
			
			//Now begins the reading of RAM and shifting it out to the VGA outputs
			2: begin
				vid<=sreg1[7];state<=3;address<=address+1;
			end
			
			3: begin
				vid<=sreg1[6];state<=4;
			end
			
			4: begin
				vid<=sreg1[5];state<=5;
			end
			
			5: begin
				vid<=sreg1[4];state<=6;
			end
			
			6: begin
				vid<=sreg1[3];state<=7;
			end
			
			7: begin
				vid<=sreg1[2];state<=8;
			end
			
			8: begin
				vid<=sreg1[1];state<=9;sreg2<=data;
			end
			
			9: begin
				vid<=sreg1[0];state<=10;
			end
			
			10: begin
				vid<=sreg2[7];state<=11;address<=address+1;
			end
			
			11: begin
				if(address==38400)
					address<=0;
				vid<=sreg2[6];state<=12;
			end
			
			12: begin
				vid<=sreg2[5];state<=13;
			end
			
			13: begin
				vid<=sreg2[4];state<=14;
			end
			
			14: begin
				vid<=sreg2[3];state<=15;
			end
			
			15: begin
				vid<=sreg2[2];state<=16;counter<=counter+1;
			end
			
			16: begin
				vid<=sreg2[1];state<=17;sreg1<=data;
			end
			
			17: begin
				vid<=sreg2[0];
				if(counter==40) begin
					state<=18;addroe<=0;
					end
				else 
					state<=2;
			end

			18: begin
				counter<=0;vid<=0;
				if(hsync==0) begin
					state<=0;
				end
			end
		endcase		
	end
end 

endmodule
