;-------------------------------------------------------------------------------
; File Name: video.asm                                                         |
; File Description: This program will receive ASCII data from the bus and      |
;                   write the corresponding bits in video memory               |
;                   once writeok asserts we have 1500 instructions             | 
;-------------------------------------------------------------------------------

	list	P=PIC16F877	; PIC16C77 Microprocessor
	include "C:\arbadell\video\P16F877.INC"; 
	radix	hex

;	cpu equates
addh	equ	0x20
addl	equ	0x21
write0	equ	0x22
write1	equ	0x23
write2	equ	0x24
write3	equ	0x25
write4	equ	0x26
write5	equ	0x27
write6	equ	0x28
write7	equ	0x29
byte	equ	0x2a
posh	equ	0x2b
posl	equ	0x2c
newlh	equ	0x2d
newll	equ	0x2e
counter equ	0x2f
pntr2	equ	0x30
pointer	equ	0x31
fsrPtr	equ	0x32

	org	0x00
start	
	;configure ports
	bcf	STATUS,RP0	;make sure in bank0
	bcf	STATUS,RP1
	movlw	0x42		;set bits for portd
	movwf	PORTD
	bsf	STATUS,RP0	;change to bank1	
	movlw	0xff		;make ports b and c input
	movwf	TRISB
	movwf	TRISC
	movlw	0x88		;configure portd
	movwf	TRISD
	movlw	0x06		;make porta digital
	movwf	ADCON1
	movlw	0xfc
	movwf	TRISA		;make bits0 and 1 output
	bcf	STATUS,RP0	;change to bank0

	;reset the CPLD
	bcf	PORTA,0

	;clear the clearing signal
	bcf	PORTA,1

	;configure the indirect pointer
	movlw	fsrPtr
	movwf	FSR
	movwf	pntr2
	movwf	pointer

	;clear registers
	clrf	addh
	clrf	addl
	clrf	posh
	clrf	posl
	clrf	newlh
	clrf	newll
	clrf	counter

	;take CPLD out of reset
	bsf	PORTA,0

	;poll the writeok and VDATA lines
poll	
	btfsc	PORTD,3		;check for VDATA	
	goto	VDATA
	goto	poll	

VDATA
	movf	PORTC,w		;grab the data from PORTC
	movwf	byte

	;This portion will write to external RAM
writeok
	bsf	PORTA,1
	bcf	PORTD,6		;enable the latches
	bsf	PORTD,0		;disable the output of external RAM
	bsf	STATUS,RP0	;change to bank1	
	movlw	0x00		;make port b output
	movwf	TRISB
	bcf	STATUS,RP0	;change to bank0

	movlw	0x0d
	xorwf	byte,w
	btfsc	STATUS,Z
	goto	newline
	movlw	0x80
	xorwf	byte,w
	btfsc	STATUS,Z
	goto	clrs
	movlw	0x08
	xorwf	byte,w
	btfsc	STATUS,Z
	goto	backsp
	call	write07		;fills the write0-7 register

	movf	posh,w
	movwf	addh
	movf	posl,w
	movwf	addl
	
writeback
	call	setaddress
	movf	write0,w
	movwf	PORTB
	bcf	PORTD,1		;write the byte to external RAM 
	nop
	bsf	PORTD,1
	call	setaddress
	movf	write1,w
	movwf	PORTB
	bcf	PORTD,1		;write the byte to external RAM 
	nop
	bsf	PORTD,1
	call	setaddress
	movf	write2,w
	movwf	PORTB
	bcf	PORTD,1		;write the byte to external RAM 
	nop
	bsf	PORTD,1
	call	setaddress
	movf	write3,w
	movwf	PORTB
	bcf	PORTD,1		;write the byte to external RAM 
	nop
	bsf	PORTD,1
	call	setaddress
	movf	write4,w
	movwf	PORTB
	bcf	PORTD,1		;write the byte to external RAM 
	nop
	bsf	PORTD,1
	call	setaddress
	movf	write5,w
	movwf	PORTB
	bcf	PORTD,1		;write the byte to external RAM 
	nop
	bsf	PORTD,1
	call	setaddress
	movf	write6,w
	movwf	PORTB
	bcf	PORTD,1		;write the byte to external RAM 
	nop
	bsf	PORTD,1
	call	setaddress
	movf	write7,w
	movwf	PORTB
	bcf	PORTD,1		;write the byte to external RAM 
	nop
	bsf	PORTD,1

	movlw	0x01
	addwf	posl,f		;go to the beginning to the next char
	btfsc	STATUS,C
	incf	posh,f

writecont
	bsf	PORTD,6		;disable the latches
	bsf	PORTD,1		;set external RAM to read	
	bsf	STATUS,RP0	;change to bank1	
	movlw	0xff		;make port b input
	movwf	TRISB
	bcf	STATUS,RP0	;change to bank0
	bcf	PORTD,0		;enable the output of external RAM
	bcf	PORTA,1

	bsf	PORTD,2		;set VACK
VDATAclear
	btfsc	PORTD,3		;wait for VDATA to clear
	goto	VDATAclear
	bcf	PORTD,2		;clear VACK
	goto	poll		;go back to polling	

setaddress
	movf	addh,w		;move high address value to PORTB
	movwf	PORTB		;and latch the value
	bsf	PORTD,4
	nop
	bcf	PORTD,4
	movf	addl,w		;do the same for the low address value
	movwf	PORTB
	bsf	PORTD,5
	nop
	bcf	PORTD,5
	movlw	0x50
	addwf	addl,f
	btfss	STATUS,C
	goto	nocarry
	incf	addh,f
nocarry
	return

;This is a subroutine that will clear the screen
clrs
	clrf	addh
	clrf	addl
clrall
	bsf	PORTA,1
	movf	addh,w		;move high address value to PORTB
	movwf	PORTB		;and latch the value
	bsf	PORTD,4
	nop
	bcf	PORTD,4
	movf	addl,w		;do the same for the low address value
	movwf	PORTB
	bsf	PORTD,5
	nop
	bcf	PORTD,5
	movlw	0x01
	addwf	addl,f
	btfsc	STATUS,C
	incf	addh,f

	movlw	0x00
	movwf	PORTB
	bcf	PORTD,1		;write the byte to external RAM 
	nop
	bsf	PORTD,1
	
clrcont
	movlw	0x96		;end of video buffer at 0x9600
	xorwf	addh,w		;test for addh to be 0x96
	btfss	STATUS,Z	;if not continue clearing
	goto	clrall
	bcf	PORTA,1
	clrf	addh		;else clear all the pointers
	clrf	addl
	clrf	posh
	clrf	posl
	clrf	newlh
	clrf	newll	
	goto	writecont

;This is a subroutine that will go to a newline
newline
	movlw	0x80		;need to add 0x280 to the newline pointer
	addwf	newll,f		
	btfsc	STATUS,C
	incf	newlh,f
	movlw	0x02
	addwf	newlh,f
	movf	newll,w		;once added then make the position pointers
	movwf	posl		;equal to the newline
	movf	newlh,w
	movwf	posh
	incf	counter,f
	goto	writecont

backsp
	movlw	0x01
	subwf	posl,f
	btfss	STATUS,C
	decf	posh,f
	movf	posl,w
	movwf	addl
	movf	posh,w
	movwf	addh
	movlw	0x01
	incf	counter,f
	clrf	write0
	clrf	write1
	clrf	write2
	clrf	write3
	clrf	write4
	clrf	write5
	clrf	write6
	clrf	write7
	movlw	0x01
	subwf	posl,f
	btfss	STATUS,C
	decf	posh,f
	goto	writeback		

;This is the portion of code that determines 
;which bits to set in external RAM
write07
	movlw	0x20
	xorwf	byte,w
	btfss	STATUS,Z
	goto	zero
	clrf	write0
	clrf	write1
	clrf	write2
	clrf	write3
	clrf	write4
	clrf	write5
	clrf	write6
	clrf	write7
	goto	writedone
	
zero
	movlw	0x30
	xorwf	byte,w
	btfss	STATUS,Z
	goto	one
	movlw	0x7c	
	movwf	write0
	movwf	write6
	movlw	0x86
	movwf	write1
	movlw	0x8a
	movwf	write2
	movlw	0x92
	movwf	write3
	movlw	0xa2
	movwf	write4
	movlw	0xc2
	movwf	write5
	clrf	write7
	goto	writedone
	
one
	movlw	0x31
	xorwf	byte,w
	btfss	STATUS,Z
	goto	two
	movlw	0x10
	movwf	write0
	movwf	write2
	movwf	write3
	movwf	write4
	movwf	write5
	movlw	0x30
	movwf	write1
	movlw	0x38
	movwf	write6
	clrf	write7
	goto	writedone

two
	movlw	0x32
	xorwf	byte,w
	btfss	STATUS,Z
	goto	three
	movlw	0x3c
	movwf	write0
	movlw	0x42
	movwf	write1
	movlw	0x04
	movwf	write2
	movlw	0x08
	movwf	write3
	movlw	0x10
	movwf	write4
	movlw	0x20
	movwf	write5
	movlw	0x7e
	movwf	write6
	clrf	write7
	goto	writedone

three
	movlw	0x33
	xorwf	byte,w
	btfss	STATUS,Z
	goto	four
	movlw	0x38
	movwf	write0
	movwf	write6
	movlw	0x04
	movwf	write1
	movwf	write2
	movwf	write4
	movwf	write5
	movlw	0x18
	movwf	write3
	clrf	write7
	goto	writedone

four
	movlw	0x34
	xorwf	byte,w
	btfss	STATUS,Z
	goto	five
	movlw	0x88
	movwf	write0
	movwf	write1
	movwf	write2
	movwf	write3
	movlw	0xf8
	movwf	write4
	movlw	0x08
	movwf	write5
	movwf	write6
	clrf	write7
	goto	writedone

five
	movlw	0x35
	xorwf	byte,w
	btfss	STATUS,Z
	goto	six
	movlw	0xf8
	movwf	write0
	movlw	0x80
	movwf	write1
	movwf	write2
	movlw	0xf0
	movwf	write3
	movlw	0x08
	movwf	write4
	movwf	write5
	movlw	0xf0
	movwf	write6
	clrf	write7
	goto	writedone

six
	movlw	0x36
	xorwf	byte,w
	btfss	STATUS,Z
	goto	seven
	movlw	0x70
	movwf	write0
	movwf	write6
	movlw	0x80
	movwf	write1
	movwf	write2
	movlw	0xf0
	movwf	write3
	movlw	0x88
	movwf	write4
	movwf	write5
	clrf	write7
	goto	writedone

seven
	movlw	0x37
	xorwf	byte,w
	btfss	STATUS,Z
	goto	eight
	movlw	0xfc
	movwf	write0
	movlw	0x84
	movwf	write1
	movlw	0x04
	movwf	write2
	movwf	write3
	movlw	0x08
	movwf	write4
	movlw	0x10
	movwf	write5
	movwf	write6
	clrf	write7
	goto	writedone

eight
	movlw	0x38
	xorwf	byte,w
	btfss	STATUS,Z
	goto	nine
	movlw	0x78
	movwf	write0
	movwf	write3
	movwf	write6
	movlw	0x84
	movwf	write2
	movwf	write1
	movwf	write4
	movwf	write5
	clrf	write7
	goto	writedone

nine
	movlw	0x39
	xorwf	byte,w
	btfss	STATUS,Z
	goto	leta
	movlw	0x78
	movwf	write0
	movwf	write3
	movlw	0x88
	movwf	write1
	movwf	write2
	movlw	0x08
	movwf	write4
	movwf	write5
	movwf	write6
	clrf	write7
	goto	writedone

leta
	movlw	0x61
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letb
	movlw	0x60
	movwf	write1
	movlw	0x10
	movwf	write2
	movlw	0x70
	movwf	write3
	movlw	0x90
	movwf	write4
	movwf	write5
	movlw	0x78
	movwf	write6
	clrf	write0
	clrf	write7
	goto	writedone

letb
	movlw	0x62
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letc
	movlw	0x80
	movwf	write0
	movwf	write1
	movwf	write2
	movlw	0xe0
	movwf	write3
	movwf	write6
	movlw	0x90
	movwf	write4
	movwf	write5
	clrf	write7
	goto	writedone

letc
	movlw	0x63
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letd
	clrf	write0
	clrf	write1
	clrf	write2
	clrf	write7
	movlw	0x70
	movwf	write3
	movwf	write6
	movlw	0x80
	movwf	write4
	movwf	write5
	goto	writedone

letd
	movlw	0x64
	xorwf	byte,w
	btfss	STATUS,Z
	goto	lete
	movlw	0x08
	movwf	write0
	movwf	write1
	movwf	write2
	movlw	0x38
	movwf	write3
	movwf	write6
	movlw	0x48
	movwf	write4
	movwf	write5
	clrf	write7
	goto	writedone

lete
	movlw	0x65
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letf
	clrf	write0
	clrf	write1
	clrf	write7
	movlw	0x70
	movwf	write2
	movlw	0x88
	movwf	write3
	movlw	0xb8
	movwf	write4
	movlw	0x80
	movwf	write5
	movlw	0x78
	movwf	write6
	goto	writedone

letf
	movlw	0x66
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letg
	movlw	0x18
	movwf	write0
	movlw	0x24
	movwf	write1
	movlw	0x20
	movwf	write2
	movwf	write4
	movwf	write5
	movwf	write6
	movlw	0x70
	movwf	write3
	clrf	write7
	goto	writedone

letg
	movlw	0x67
	xorwf	byte,w
	btfss	STATUS,Z
	goto	leth
	clrf	write0
	movlw	0x1c
	movwf	write1
	movwf	write4
	movlw	0x24
	movwf	write2
	movwf	write3
	movlw	0x04
	movwf	write5
	movlw	0x44
	movwf	write6
	movlw	0x38
	movwf	write7
	goto	writedone

leth
	movlw	0x68
	xorwf	byte,w
	btfss	STATUS,Z
	goto	leti
	movlw	0x40
	movwf	write0
	movwf	write1
	movwf	write2
	movlw	0x58
	movwf	write3
	movlw	0x64
	movwf	write4
	movlw	0x44
	movwf	write5
	movwf	write6
	clrf	write7
	goto	writedone

leti
	movlw	0x69
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letj
	movlw	0x18
	movwf	write1
	movwf	write4
	movwf	write5
	movwf	write6
	clrf	write0
	clrf	write2
	clrf	write7
	clrf	write3
	goto	writedone

letj
	movlw	0x6a
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letk
	movlw	0x08
	movwf	write1
	movwf	write3
	movwf	write4
	movwf	write5
	movlw	0x48
	movwf	write6
	movlw	0x30
	movwf	write7
	clrf	write0
	clrf	write2
	goto	writedone

letk
	movlw	0x6b
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letl
	movlw	0x20
	movwf	write0
	movwf	write1
	movlw	0x24
	movwf	write2
	movwf	write6
	movlw	0x28
	movwf	write3
	movwf	write5
	movlw	0x30
	movwf	write4
	clrf	write7
	goto	writedone

letl
	movlw	0x6c
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letm
	movlw	0x18
	movwf	write0
	movwf	write1
	movwf	write2
	movwf	write3
	movwf	write4
	movwf	write5
	movwf	write6
	clrf	write7
	goto	writedone

letm
	movlw	0x6d
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letn
	clrf	write0
	clrf	write1
	clrf	write7
	movlw	0x80
	movwf	write2
	movlw	0xec
	movwf	write3
	movlw	0x92
	movwf	write4
	movwf	write5
	movwf	write6
	goto	writedone

letn
	movlw	0x6e
	xorwf	byte,w
	btfss	STATUS,Z
	goto	leto
	clrf	write0
	clrf	write1
	clrf	write7
	movlw	0x20
	movwf	write2
	movlw	0x38
	movwf	write3
	movlw	0x24
	movwf	write4
	movwf	write5
	movwf	write6
	goto	writedone

leto
	movlw	0x6f
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letp
	clrf	write0
	clrf	write1
	clrf	write7
	movlw	0x38
	movwf	write2
	movwf	write6
	movlw	0x44
	movwf	write3
	movwf	write4
	movwf	write5
	goto	writedone

letp
	movlw	0x70
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letq
	clrf	write0
	clrf	write1
	movlw	0x1c
	movwf	write2
	movlw	0x22
	movwf	write3
	movwf	write4
	movlw	0x3c
	movwf	write5
	movlw	0x20
	movwf	write6
	movwf	write7
	goto	writedone

letq
	movlw	0x71
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letr
	clrf	write0
	clrf	write1
	clrf	write7
	movlw	0x70
	movwf	write2
	movlw	0x88
	movwf	write3
	movwf	write4
	movlw	0x7a
	movwf	write5
	movlw	0x0c
	movwf	write6
	movlw	0x08
	movwf	write7
	goto	writedone

letr
	movlw	0x72
	xorwf	byte,w
	btfss	STATUS,Z
	goto	lets
	clrf	write0
	clrf	write1
	clrf	write7
	movlw	0x20
	movwf	write2
	movlw	0x38
	movwf	write3
	movlw	0x24
	movwf	write4
	movlw	0x20
	movwf	write5
	movwf	write6
	goto	writedone

lets					
	movlw	0x73
	xorwf	byte,w
	btfss	STATUS,Z
	goto	lett
	clrf	write0
	clrf	write1
	clrf	write7
	movlw	0x1c
	movwf	write2
	movlw	0x20
	movwf	write3
	movlw	0x18
	movwf	write4
	movlw	0x04
	movwf	write5
	movlw	0x38
	movwf	write6
	goto	writedone

lett
	movlw	0x74
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letu
	clrf	write0
	clrf	write1
	clrf	write7
	movlw	0x10
	movwf	write2
	movwf	write4
	movlw	0x38
	movwf	write3
	movlw	0x14
	movwf	write5
	movlw	0x18
	movwf	write6
	goto	writedone

letu
	movlw	0x75
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letv
	clrf	write0
	clrf	write1
	clrf	write7
	clrf	write2
	movlw	0x24
	movwf	write3
	movwf	write4
	movwf	write5
	movlw	0x18
	movwf	write6
	goto	writedone

letv
	movlw	0x76
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letw
	clrf	write0
	clrf	write1
	clrf	write7
	clrf	write2
	movlw	0x44
	movwf	write3
	movwf	write4
	movlw	0x28
	movwf	write5
	movlw	0x10
	movwf	write6
	goto	writedone

letw
	movlw	0x77
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letx
	clrf	write0
	clrf	write1
	clrf	write7
	clrf	write2
	movlw	0x54
	movwf	write3
	movwf	write4
	movwf	write5
	movlw	0x28
	movwf	write6
	goto	writedone

letx
	movlw	0x78
	xorwf	byte,w
	btfss	STATUS,Z
	goto	lety
	clrf	write0
	clrf	write1
	clrf	write7
	movlw	0x44
	movwf	write2
	movwf	write6
	movlw	0x28
	movwf	write3
	movwf	write5
	movlw	0x10
	movwf	write4
	goto	writedone

lety
	movlw	0x79
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letz
	clrf	write0
	clrf	write1
	movlw	0x24
	movwf	write2
	movwf	write3
	movlw	0x1c
	movwf	write4
	movlw	0x04
	movwf	write5
	movwf	write6
	movlw	0x38
	movwf	write7
	goto	writedone

letz
	movlw	0x7a
	xorwf	byte,w
	btfss	STATUS,Z
	goto	period
	clrf	write0
	clrf	write1
	clrf	write7
	movlw	0x7c
	movwf	write2
	movwf	write6
	movlw	0x08
	movwf	write3
	movlw	0x10
	movwf	write4
	movlw	0x20
	movwf	write5
	goto	writedone

period
	movlw	0x2e
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letA
	clrf	write0
	clrf	write1
	clrf	write7
	clrf	write2
	clrf	write3
	clrf	write4
	movlw	0x18
	movwf	write5
	movwf	write6
	goto	writedone

letA
	movlw	0x41
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letB
	movlw	0x10
	movwf	write0
	movlw	0x28
	movwf	write1
	movlw	0x44
	movwf	write2
	movwf	write3
	movwf	write5
	movwf	write6
	movlw	0x7c
	movwf	write4
	clrf	write7
	goto	writedone

letB
	movlw	0x42
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letC
	movlw	0x70
	movwf	write0
	movwf	write6
	movwf	write3
	movlw	0x48
	movwf	write1
	movwf	write2
	movwf	write4
	movwf	write5
	clrf	write7
	goto	writedone

letC
	movlw	0x43
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letD
	movlw	0x3c
	movwf	write0
	movwf	write6
	movlw	0x40
	movwf	write1
	movwf	write2
	movwf	write3
	movwf	write4
	movwf	write5
	clrf	write7
	goto	writedone

letD
	movlw	0x44
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letE
	movlw	0x78
	movwf	write0
	movwf	write6
	movlw	0x44
	movwf	write1
	movwf	write2
	movwf	write3
	movwf	write4
	movwf	write5
	clrf	write7
	goto	writedone

letE
	movlw	0x45
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letF
	movlw	0x78
	movwf	write0
	movwf	write6
	movlw	0x40
	movwf	write1
	movwf	write2
	movwf	write4
	movwf	write5
	movlw	0x70
	movwf	write3
	clrf	write7
	goto	writedone

letF
	movlw	0x46
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letG
	movlw	0x78
	movwf	write0
	movlw	0x40
	movwf	write1
	movwf	write3
	movwf	write4
	movwf	write5
	movwf	write6
	movlw	0x70
	movwf	write2
	clrf	write7
	goto	writedone

letG
	movlw	0x47
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letH
	movlw	0x3c
	movwf	write0
	movwf	write6
	movlw	0x40
	movwf	write1
	movwf	write2
	movwf	write3
	movlw	0x5c
	movwf	write4
	movlw	0x44
	movwf	write5
	clrf 	write7
	goto	writedone

letH
	movlw	0x48
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letI
	movlw	0x44
	movwf	write0
	movwf	write1
	movwf	write2
	movwf	write4
	movwf	write5
	movwf	write6
	movlw	0x7c
	movwf	write3
	clrf	write7
	goto	writedone

letI
	movlw	0x49
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letJ
	movlw	0x7c
	movwf	write0
	movwf	write6
	movlw	0x10
	movwf	write1
	movwf	write2
	movwf	write3
	movwf	write4
	movwf	write5
	clrf	write7
	goto	writedone

letJ
	movlw	0x4a
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letK
	movlw	0x3e
	movwf	write0
	movlw	0x08
	movwf	write1
	movwf	write2
	movwf	write3
	movlw	0x28
	movwf	write4
	movwf	write5
	movlw	0x10
	movwf	write6
	clrf	write7
	goto	writedone

letK
	movlw	0x4b
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letL
	movlw	0x48
	movwf	write0
	movwf	write4
	movlw	0x50
	movwf	write1
	movwf	write3
	movlw	0x60
	movwf	write2
	movlw	0x44
	movwf	write5
	movwf	write6
	clrf	write7
	goto	writedone

letL
	movlw	0x4c
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letM
	movlw	0x40
	movwf	write0
	movwf	write1
	movwf	write2
	movwf	write3
	movwf	write4
	movwf	write5
	movlw	0x78
	movwf	write6
	clrf	write7
	goto	writedone

letM
	movlw	0x4d
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letN
	movlw	0x44
	movwf	write0
	movwf	write3
	movwf	write4
	movwf	write5
	movwf	write6
	movlw	0x6c
	movwf	write1
	movlw	0x54
	movwf	write2
	clrf	write7
	goto	writedone

letN
	movlw	0x4e
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letO
	movlw	0x42
	movwf	write0
	movwf	write5
	movwf	write6
	movlw	0x62
	movwf	write1
	movlw	0x52
	movwf	write2
	movlw	0x4a
	movwf	write3
	movlw	0x46
	movwf	write4
	clrf	write7
	goto	writedone

letO
	movlw	0x4f
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letP
	movlw	0x38
	movwf	write0
	movwf	write6
	movlw	0x44
	movwf	write1
	movwf	write2
	movwf	write3
	movwf	write4
	movwf	write5
	clrf	write7
	goto	writedone

letP
	movlw	0x50
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letQ
	movlw	0x78
	movwf	write0
	movwf	write3
	movlw	0x44
	movwf	write1
	movwf	write2
	movlw	0x40
	movwf	write4
	movwf	write5
	movwf	write6
	clrf	write7
	goto	writedone

letQ
	movlw	0x51
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letR			
	movlw	0x38
	movwf	write0
	movlw	0x44
	movwf	write1
	movwf	write2
	movwf	write3
	movwf	write4
	movlw	0x4c
	movwf	write5
	movlw	0x3c
	movwf	write6
	clrf	write7
	goto	writedone

letR
	movlw	0x52
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letS
	movlw	0x78
	movwf	write0
	movwf	write3
	movlw	0x44
	movwf	write1
	movwf	write2
	movwf	write6
	movlw	0x50
	movwf	write4
	movlw	0x48
	movwf	write5
	clrf	write7
	goto	writedone

letS
	movlw	0x53
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letT
	movlw	0x3c
	movwf	write0
	movlw	0x40
	movwf	write1
	movwf	write2
	movlw	0x04
	movwf	write4
	movwf	write5
	movlw	0x38
	movwf	write3
	movlw	0x78
	movwf	write6
	clrf	write7
	goto	writedone

letT
	movlw	0x54
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letU
	movlw	0x7c
	movwf	write0
	movlw	0x10
	movwf	write1
	movwf	write2
	movwf	write3
	movwf	write4
	movwf	write5
	movwf	write6
	clrf	write7
	goto	writedone
		
letU
	movlw	0x55
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letV
	movlw	0x44
	movwf	write0
	movwf	write1
	movwf	write2
	movwf	write3
	movwf	write4
	movwf	write5
	movlw	0x38
	movwf	write6
	clrf	write7
	goto	writedone

letV
	movlw	0x56
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letW
	movlw	0x44
	movwf	write0
	movwf	write1
	movwf	write2
	movwf	write3
	movwf	write4
	movlw	0x28
	movwf	write5
	movlw	0x10
	movwf	write6
	clrf	write7
	goto	writedone

letW
	movlw	0x57
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letX
	movlw	0x44
	movwf	write0
	movwf	write1
	movwf	write2
	movwf	write3
	movwf	write6
	movlw	0x54
	movwf	write4
	movlw	0x6c
	movwf	write5
	clrf	write7
	goto	writedone

letX
	movlw	0x58
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letY
	movlw	0x44
	movwf	write0
	movwf	write1
	movwf	write5
	movwf	write6
	movlw	0x28
	movwf	write2
	movwf	write4
	movlw	0x10
	movwf	write3
	clrf	write7
	goto	writedone

letY
	movlw	0x59
	xorwf	byte,w
	btfss	STATUS,Z
	goto	letZ
	movlw	0x44
	movwf	write0
	movwf	write1
	movlw	0x28
	movwf	write2
	movlw	0x10
	movwf	write3
	movwf	write4
	movwf	write5
	movwf	write6
	clrf	write7
	goto	writedone

letZ
	movlw	0x5a
	xorwf	byte,w
	btfss	STATUS,Z
	goto	smiley
	movlw	0x7c
	movwf	write0
	movwf	write6
	movlw	0x04
	movwf	write1
	movlw	0x08
	movwf	write2
	movlw	0x10
	movwf	write3
	movlw	0x20
	movwf	write4
	movlw	0x40
	movwf	write5
	clrf 	write7
	goto	writedone
						
smiley
	movlw	0x6a
	movwf	write0
	movwf	write7
	movlw	0x42
	movwf	write1
	movwf	write6
	movlw	0xa5
	movwf	write2
	movwf	write4
	movlw	0x81
	movwf	write3
	movlw	0x99
	movwf	write5

writedone
	incf	counter,f
	return

	end		
