/* * * * * * * * * * * * * * * * * * * * * * * *
 *  This is the assembler for the Arbadell CPU *
 *  File Name:   ass.c                         *
 *  Written by:  Shane Avery                   *
 * * * * * * * * * * * * * * * * * * * * * * * */

#include<stdio.h>
#include<stdlib.h>
#include<errno.h>
#include<string.h>

/* This is a function that will return a one if the -v flag was entered */
int verbose(int argc, char *argv[])
{
 int value=0;
 if(argc == 3)
 {
	if( (strncmp(argv[2],"-v",2) == 0) )
		value=1;

 }
 else if(argc == 4)
 {
	if( (strncmp(argv[2],"-v",2) == 0) || (strncmp(argv[3],"-v",2) == 0) )
		value=1;
 }
 else if(argc == 5)
 {
	if( (strncmp(argv[2],"-v",2) == 0) || (strncmp(argv[3],"-v",2) == 0) || (strncmp(argv[4],"-v",2) == 0) )
		value=1;
 }
 return value;
}

/* This is a function that will return a one if the -d flag was entered */
int del(int argc, char *argv[])
{
 int value=0;
 if(argc == 3)
 {
	if( (strncmp(argv[2],"-d",2) == 0) )
		value=1;

 }
 else if(argc == 4)
 {
	if( (strncmp(argv[2],"-d",2) == 0) || (strncmp(argv[3],"-d",2) == 0) )
		value=1;
 }
 else if(argc == 5)
 {
	if( (strncmp(argv[2],"-d",2) == 0) || (strncmp(argv[3],"-d",2) == 0) || (strncmp(argv[4],"-d",2) == 0) )
		value=1;
 }
 return value;
}


/* This is my function that will convert ASCII to integer numbers */
int convert(char ch)
{
 int number;
 if(ch < 0x40 && ch > 0x29)
 {
        number = ch-0x30;
 }
 else
 {
        if(ch == 'a' || ch == 'A') number = 10;
        else if(ch == 'b' || ch == 'B') number = 11;
        else if(ch == 'c' || ch == 'C') number = 12;
        else if(ch == 'd' || ch == 'D') number = 13;
        else if(ch == 'e' || ch == 'E') number = 14;
        else number = 15;
 }
 return number;
}

/* This is function to verify the arguement is hex and */
/* to convert it to lower case if needed */
void ver(char *ch1, char *ch2, int line)
{

 /* Verify that the arguement are hex numbers */
 if(*ch1 < 0x30 || *ch2 < 0x30 || *ch1 > 0x66 || *ch2 > 0x66)
 {
	printf("Error in line: %i. Arguement must be hex\n", line+1);
	exit(1);
 }
 if((*ch1 > 0x39 && *ch1 < 0x41) || (*ch2 > 0x39 && *ch2 < 0x41))
 {
	printf("Error in line: %i. Arguement must be hex\n", line+1);
	exit(1);
 }
 if((*ch1 > 0x46 && *ch1 < 0x61) || (*ch2 > 0x46 && *ch2 < 0x61))
 {
	printf("Error in line: %i. Arguement must be hex\n", line+1);
	exit(1);
 }

 /* Convert upper case to lower case */
 if(*ch1 >= 0x41 && *ch1 <= 0x46)
	*ch1=*ch1+0x20;

 if(*ch2 >= 0x41 && *ch2 <= 0x46)
	*ch2=*ch2+0x20;

 return;
}


int main(int argc, char *argv[])
{
 FILE *fp,*fp2,*fp3,*fp4;
 char string[100];
 char string2[100];
 char tempstring[100];
 char value[10];
 int i=0;
 int index, index2;
 char data;
 unsigned int addr=0;
 int temp,line=0;
 int first=0;
 int first_org=0;
 char ch,ch2;
 int tempch, match, itemp, size, newline, org, written;
 extern int errno;

 /* If the assembler doesn't get a file or if the second */
 /* arguement asks for help then print this message */
 if(argc >= 5)
	{
 		if((argv[1][0] == '-' && argv[1][1] == 'h') || (argv[2][0] == '-' && argv[2][1] == 'h')
			|| (argv[3][0] == '-' && argv[3][1] == 'h') || (argv[4][0] == '-' && argv[4][1] == 'h'|| argc > 5))
 		{
			puts("usage: ass inputfilename outputfilename [-h][-d][-v]");
			puts("-h:    This message");
			puts("-d:    Do not delete arb.tmp or arb.map (for debugging)");
			puts("-v:    Verbose");
			if(argc > 6)
				puts("Error: Too many arguements");
			exit(1);
 		}
	}
 else if(argc == 4)
 	{
		if((argv[1][0] == '-' && argv[1][1] == 'h') || (argv[2][0] == '-' && argv[2][1] == 'h')
			|| (argv[3][0] == '-' && argv[3][1] == 'h'))
 		{
			puts("usage: ass inputfilename outputfilename [-h][-d][-v]");
			puts("-h:    This message");
			puts("-d:    Do not delete arb.tmp or arb.map (for debugging)");
			puts("-v:    Verbose");
			exit(1);
 		}
	}
 else if(argc == 3)
 	{
		if((argv[1][0] == '-' && argv[1][1] == 'h') || (argv[2][0] == '-' && argv[2][1] == 'h'))
 		{
			puts("usage: ass inputfilename outputfilename [-h][-d][-v]");
			puts("-h:    This message");
			puts("-d:    Do not delete arb.tmp or arb.map (for debugging)");
			puts("-v:    Verbose");
			exit(1);
 		}
	}
 else if(argc == 2)
 	{
		if((argv[1][0] == '-' && argv[1][1] == 'h'))
 		{
			puts("usage: ass inputfilename outputfilename [-h][-d][-v]");
			puts("-h:    This message");
			puts("-d:    Do not delete arb.tmp or arb.map (for debugging)");
			puts("-v:    Verbose");
			exit(1);
 		}
	}
 else
 	{
		puts("usage: ass inputfilename outputfilename [-h][-d][-v]");
		puts("-h:    This message");
		puts("-d:    Do not delete arb.tmp or arb.map (for debugging)");
		puts("-v:    Verbose");
		exit(1);
 	}


 /* Open the file name of the next arguement */
 if(argv[1][0] != '-')
 {
        fp=fopen(&argv[1][0],"r");
 }
 else
 {
        puts("The first arguement needs to be the input file");
		exit(1);
 }

 /* Write the result to arb.txt by default or the outputfile name */
 if(argc < 3)
        fp2=fopen("arb.txt", "w");
 else if(argc == 3)
 {
	if(argv[2][0] != '-')
        	fp2=fopen(&argv[2][0],"w");
	else
        	fp2=fopen("arb.txt","w");
 }
 else if(argc == 4)
 {
	if(argv[2][0] != '-')
        	fp2=fopen(&argv[2][0],"w");
	else if(argv[3][0] != '-')
        	fp2=fopen(&argv[3][0],"w");
	else
        	fp2=fopen("arb.txt","w");
 }
 else if(argc == 5)
 {
	if(argv[2][0] != '-')
        	fp2=fopen(&argv[2][0],"w");
	else if(argv[3][0] != '-')
        	fp2=fopen(&argv[3][0],"w");
	else if(argv[4][0] != '-')
        	fp2=fopen(&argv[4][0],"w");
	else
        	fp2=fopen("arb.txt","w");
 }

 fp3=fopen("arb.map", "w+");
 fp4=fopen("arb.tmp", "w+");

 /* If the file opens failed */
 if(fp==NULL)
 {
	puts("fopen() failed. (fp)");
	exit(1);
 }
 if(fp2==NULL)
 {
	puts("fopen() failed. (fp2)");
	exit(1);
 }
 if(fp3==NULL)
 {
	puts("fopen() failed. (fp3)");
	exit(1);
 }
 if(fp4==NULL)
 {
	puts("fopen() failed. (fp4)");
	exit(1);
 }

 rewind(fp);

 if( verbose(argc, argv) )
 {
	puts("All files opened successfully");
	printf("Getting label addresses and equate values......");
 }


 /* This portion will write the address of labels to a file */
 while(1)
 {
	char tempstring[100];
	/* Get the next string */
 	fgets(string, 100, fp);

	/* If the next string is a comment then ignore */
 	while(string[0] == ';' || string[0] == '\n')
    {
        line++;
		fgets(string, 100, fp);
    }

	/* If the next string is end then break out of loop */
	if(strncmp(string, "end", 3) == 0 || strncmp(string, "\tend",4) == 0)
		break;

	/* If there is a label in the first column then try to extract it and the address */
	if(string[0] != ' ' && string[0] != '\t')
	{
		for(index=1;(string[index] != '\n') && (string[index] != '\t') && (string[index] != ' ') ;index++);
		string[index]='\n';string[index+1]=0;

		if(string[0] != '0' && string[1] != 'x')
		{
			if((strncmp(string, "org", 3) != 0) && (strncmp(string, "movel", 5) != 0) &&
			(strncmp(string, "movem", 5) != 0) && (strncmp(string, "moves", 5) != 0) &&
			(strncmp(string, "inv", 3) != 0) && (strncmp(string, "inc", 3) != 0) &&
			(strncmp(string, "ret", 3) != 0) && (strncmp(string, "dec", 3) != 0) &&
			(strncmp(string, "bra", 3) != 0) && (strncmp(string, "braz", 4) != 0) &&
			(strncmp(string, "call", 4) != 0) && (strncmp(string, "orm", 3) != 0) &&
			(strncmp(string, "orl", 3) != 0) && (strncmp(string, "addm", 4) != 0) &&
			(strncmp(string, "addl", 4) != 0) && (strncmp(string, "andm", 4) != 0) &&
			(strncmp(string, "andl", 4) != 0) && (strncmp(string, "shiftr", 6) != 0) &&
			(strncmp(string, "shiftl", 6) != 0) && (strncmp(string, "equ", 3) != 0) &&
			(strncmp(string, "dc", 2) != 0) && (strncmp(string, "reti", 4) != 0) &&
			(strncmp(string, "setie", 5) != 0) && (strncmp(string, "ti0", 3) != 0) &&
			(strncmp(string, "iosend", 6) != 0) && (strncmp(string, "ti1", 3) != 0) &&
			(strncmp(string, "iorecv", 6) != 0) )
			{
				if(addr < 0x10)
					fprintf(fp3, "%s000%x\n", string, addr);
		        else if(addr < 0x100)
		            fprintf(fp3, "%s00%x\n", string, addr);
		        else if(addr < 0x1000)
		            fprintf(fp3, "%s0%x\n", string, addr);
		        else
		            fprintf(fp3, "%s%x\n", string, addr);
            }
		}
		else
		{
			puts("Error: Can't have a label begin with 0x. It could be mistaken for a hex number");
			exit(1);
		}
	}
	else
	{
		i=0;
		while(string[i] == ' ' || string[i] == '\t')
			i++;
    	/* Implements assembler directive ORG */
		if(strncmp(&string[i], "org", 3) == 0)
		{
			i=i+3;
			while(string[i] == ' ' || string[i] == '\t')
				i++;
            if(string[i] == '0' && string[i+1] == 'x')
            	i=i+2;
			addr=convert(string[i]);
			addr=addr*16*16*16;
			temp=convert(string[i+1]);
			temp=temp*16*16;
			addr=addr+temp;
			temp=convert(string[i+2]);
			temp=temp*16;
			addr=addr+temp;
			temp=convert(string[i+3]);
			addr=addr+temp;
		}

		/* Implements assembler directive EQU */
		else if(strncmp(&string[i], "equ", 3) == 0)
		{
			i=i+3;
			temp=0;
			/* Grap up all the white space characters */
			while(string[i]==' ' || string[i]=='\t')
				i++;

			/* Then grab the label */
			for(;(string[i]!=' ' && string[i]!='\t');i++)
			{
				tempstring[temp]=string[i];
				temp++;
			}
			/* Terminate the label string and then write it to fp3 */
			tempstring[temp]='\n';tempstring[temp+1]=0;
			fprintf(fp3,"%s",tempstring);

			/* Again grap up all white space */
			while(string[i]==' ' || string[i]=='\t')
				i++;

			temp=0;
			/* Now grab the address for the label */
			for(;(string[i]!=' ' && string[i]!='\t' && string[i]!='\n');i++)
			{
				tempstring[temp]=string[i];
				temp++;
			}
			tempstring[temp]='\n';tempstring[temp+1]=0;
			if(tempstring[0]=='0' && tempstring[1]=='x')
				fprintf(fp3,"%s",&tempstring[2]);
			else
				fprintf(fp3,"%s",tempstring);
		}


  		/* This looks at the instructions and increments the */
   		/* value of address accordingly and write the address */
    	/* of any label to a temp file */
    	else if(strncmp(&string[i], "movel", 5) == 0)
    	{
    		addr=addr+2;
    	}
    	else if(strncmp(&string[i], "movem", 5) == 0)
    	{
    	    addr=addr+3;
    	}
    	else if(strncmp(&string[i], "moves", 5) == 0)
    	{
    	    addr=addr+3;
    	}
    	else if(strncmp(&string[i], "inv", 3) == 0)
    	{
    	    addr++;
    	}
    	else if(strncmp(&string[i], "inc", 3) == 0)
    	{
    	    addr++;
    	}
    	else if(strncmp(&string[i], "dec", 3) == 0)
    	{
    	    addr++;
    	}
    	else if(strncmp(&string[i], "shiftr", 6) == 0)
    	{
    	    addr++;
    	}
    	else if(strncmp(&string[i], "shiftl", 6) == 0)
    	{
    	    addr++;
    	}
    	else if(strncmp(&string[i], "addl", 4) == 0)
    	{
    	    addr=addr+2;
    	}
    	else if(strncmp(&string[i], "andl", 4) == 0)
    	{
    	    addr=addr+2;
    	}
    	else if(strncmp(&string[i], "orl", 3) == 0)
    	{
    	    addr=addr+2;
		}
    	else if(strncmp(&string[i], "addm", 4) == 0)
    	{
			addr=addr+3;
    	}
    	else if(strncmp(&string[i], "andm", 4) == 0)
    	{
    	    addr=addr+3;
    	}
    	else if(strncmp(&string[i], "orm", 3) == 0)
    	{
    	    addr=addr+3;
    	}
    	else if(strncmp(&string[i], "call", 4) == 0)
    	{
    	    addr=addr+3;
    	}
    	else if(strncmp(&string[i], "braz", 4) == 0)
    	{
    	    addr=addr+3;
    	}
    	else if(strncmp(&string[i], "bra", 3) == 0)
    	{
			addr=addr+3;
    	}
    	else if(strncmp(&string[i], "ret", 3) == 0)
    	{
    	    addr++;
    	}
		else if(strncmp(&string[i], "reti", 4) == 0)
    	{
    	    addr++;
    	}
		else if(strncmp(&string[i], "setie", 5) == 0)
    	{
    	    addr=addr+2;
    	}
		else if(strncmp(&string[i], "ti0", 3) == 0)
    	{
    	    addr=addr+3;
    	}
		else if(strncmp(&string[i], "ti1", 3) == 0)
    	{
    	    addr=addr+3;
    	}
		else if(strncmp(&string[i], "iosend", 6) == 0)
    	{
    	    addr=addr+2;
    	}
		else if(strncmp(&string[i], "iorecv", 6) == 0)
    	{
    	    addr=addr+2;
    	}
		else if(strncmp(&string[i], "dc", 2) == 0)
    	{
    	    addr=addr+2;
		}
    	else if((strncmp(&string[i], "org", 3) == 0) || (strncmp(&string[i], "\n", 1) == 0) ||
			    (strncmp(&string[i], "\t", 1) == 0) || (strncmp(&string[i], ";", 1) == 0) ||
			    (strncmp(&string[i], "equ", 3) == 0) )
    	{
    	    /* do nothing */
    	}
		else
		{
    	 	if( verbose(argc, argv) )
 			{
				printf("Suspected bad opcode near line %i\n", addr);
 			}
		}
	}

 	/* If for whatever reason we reach an eof then break */
	if(feof(fp)) break;
        line++;
 }

  /* Send the FILE pointer for the map file to the beginning */
  rewind(fp3);
  rewind(fp);
 if( verbose(argc, argv) )
 {
	printf("done\n");
	printf("Replacing labels and equates in source.......");
 }

  /* Replace the lables in the temp file */
 fgets(string, 100, fp);
 while(!feof(fp))
 {
	 written=0;
	/* Check for the end of the assembler source file */
	if(strncmp(string, "end", 3)==0 ||strncmp(string, "\tend",4) == 0)
		break;

	/* See if there is a label in the first column */
	/* If there is try to remove it */
	if(string[0] != ';' && string[0] != '\n' && string[0] != ' ' && string[0] != '\t')
	{
		i=0;
		while(string[i] != ';' && string[i] != '\n' && string[i] != ' ' && string[i] != '\t')
			i++;
		strcpy(tempstring,&string[i]);
		strcpy(string,tempstring);
	}

	/* Check to see if line begins with comment or newline */
    if(string[0] == ';' || string[0] == '\n')
	{
		fputs(string,fp4);
	}

	/* If line starts with a tab or space then assume it is an instruction */
	else if(string[0] == '\t' || string[0] == ' ')
    {
		i=0;
		/* Grab all the tabs and spaces */
		while(string[i]==' ' || string[i]=='\t')
			i++;

		/* Check for comment */
		if(string[i] == ';')
		{
			fputs(string,fp4);
			written=1;
		}

		/* Grab instruction */
		while(string[i]!=' ' && string[i]!='\t' && string[i]!='\n')
			i++;

		/* Grab all tabs and spaces after instruction */
		while(string[i]==' ' || string[i]=='\t')
			i++;

		/* If there is a newline or comment then no arguements */
		if((string[i]=='\n' || string[i]==';') && written==0)
			fputs(string,fp4);

		/* Check if arguements already in hex format */
		else if(string[i] == '0' && string[i+1] == 'x')
			fputs(string,fp4);

		/* Else there are arguements and try to find a match */
        else
        {
			match=0;

			/* Get the string and value of next label */
			fgets(string2,100,fp3);
			fgets(value,10,fp3);

			/* Continue through fp3 until a match or end of file */
			while(match==0 && !feof(fp3))
			{
				itemp=i;index=0;
                while(string2[index] != '\n')
                {
               		if(string[itemp] == string2[index])
                    {
                    	match=1;
                    	itemp++;index++;
                    }
                    else
                    {
                   		match=0;
                   		break;
                    }
                }

				/* This is to handle a label that is the same only up to the */
				/* actual characters checked. Example: before this labels like */
				/* loop and loop2 would be seen as just loop */
				if((string[itemp] == '\t' || string[itemp] == ' ' ||
				   string[itemp] == '\n' || string[itemp] == 0 ||
				   string[itemp] == 13) && match==1)
					match=1;
				else
					match=0;
				/* Only grab next two if no match */
				if(match == 0)
				{
					fgets(string2,100,fp3);
					fgets(value,10,fp3);
				}
			}

			/* If you do get a match then attempt to replace */
            index=0;
            if(match == 1)
            {
				string[i]='0';string[i+1]='x';
				i=i+2;

                while(value[index] != '\n')
                {
                	string[i]=value[index];
                    index++;i++;
                }
                string[i]='\n';string[i+1]=0;
                fputs(string,fp4);
            }
    	}
	}

    rewind(fp3);
	fgets(string, 100, fp);

  }

 if( verbose(argc, argv) )
 {
	printf("done\n");
	printf("arb.tmp written\n");
	printf("Assembling code.........");
 }

 rewind(fp4);
 line=0;addr=0;first=0;first_org=0;
 /* This will decode the assembly instructions */
 while(1)
 {
	org=0;
	/* Get the next string */
	if(fgets(string, 100, fp4) == NULL)
		break;

	/* If the next string is a comment then ignore */
 	while(string[0] == ';')
    {
        line++;
		fgets(string, 100, fp4);
    }

	/* If the next string is end then break out of loop */
	if(strncmp(string, "end", 3)==0 || strncmp(string, "\tend",4) == 0)
		break;

	/* Consume all the tabs and spaces */
	i=0;
	while(string[i] == '\t' || string[i] == ' ')
			i++;

    /* Implements assembler directive ORG */
	if(strncmp(&string[i], "org", 3) == 0)
	{
		i=i+3;
		/* Consume all the tabs and spaces */
		while(string[i] == '\t' || string[i] == ' ')
			i++;

        if(string[i] == '0' && string[i+1] == 'x')
            i=i+2;

		addr=convert(string[i]);
		addr=addr*16*16*16;
		temp=convert(string[i+1]);
		temp=temp*16*16;
		addr=addr+temp;
		temp=convert(string[i+2]);
		temp=temp*16;
		addr=addr+temp;
		temp=convert(string[i+3]);
		addr=addr+temp;
        fprintf(fp2, ":%x ", addr);
        first_org=1;
		org=1;
	}

    /* The file needs to start with an address */
    if(first==0 && first_org==0)
    {
        fprintf(fp2, ":%i ", addr);
        first=1;
    }


    /* This decodes the assembly instructions. It will verify that the */
	/* arguements are hex, make the arguements lower case if needed, and */
	/* will accept 0x format for hex numbers as arguements. */
	if(strncmp(&string[i], "movel", 5) == 0)
    {
		i=i+5;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
            fprintf(fp2, "00%c%c", ch, ch2);
		}
		else
		{
            printf("Error (movel). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "movem", 5) == 0)
     {
		i=i+5;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
            fprintf(fp2, "01%c%c", ch, ch2);
            ch=string[11];ch2=string[12];
			ver(&ch,&ch2,line);
            fprintf(fp2, "%c%c", ch, ch2);
		}
		else
		{
            printf("Error (movem). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "moves", 5) == 0)
     {
		i=i+5;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
            fprintf(fp2, "02%c%c", ch, ch2);
            ch=string[11];ch2=string[12];
			ver(&ch,&ch2,line);
            fprintf(fp2, "%c%c", ch, ch2);
		}
		else
		{
            printf("Error (moves). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "inv", 3) == 0)
     {
                fprintf(fp2, "03");
     }
     else if(strncmp(&string[i], "inc", 3) == 0)
     {
             fprintf(fp2, "04");
     }
     else if(strncmp(&string[i], "dec", 3) == 0)
     {
             fprintf(fp2, "05");
     }
     else if(strncmp(&string[i], "shiftr", 6) == 0)
     {
             fprintf(fp2, "06");
     }
     else if(strncmp(&string[i], "shiftl", 6) == 0)
     {
             fprintf(fp2, "07");
     }
     else if(strncmp(&string[i], "addl", 4) == 0)
     {
		i=i+4;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
                	fprintf(fp2, "08%c%c", ch, ch2);
		}
		else
		{
            printf("Error (addl). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "andl", 4) == 0)
     {
		i=i+4;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
            fprintf(fp2, "09%c%c", ch, ch2);
		}
		else
		{
            printf("Error (andl). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "orl", 3) == 0)
     {
		i=i+3;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
            fprintf(fp2, "0a%c%c", ch, ch2);
		}
		else
		{
            printf("Error (orl). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "addm", 4) == 0)
     {
		i=i+4;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
            fprintf(fp2, "0b%c%c", ch, ch2);
            ch=string[10];ch2=string[11];
			ver(&ch,&ch2,line);
            fprintf(fp2, "%c%c", ch, ch2);
		}
		else
		{
            printf("Error (addm). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "andm", 4) == 0)
     {
		i=i+4;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "0c%c%c", ch, ch2);
           	ch=string[10];ch2=string[11];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "%c%c", ch, ch2);
		}
		else
		{
           	printf("Error (andm). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "orm", 3) == 0)
     {
		i=i+3;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "0d%c%c", ch, ch2);
           	ch=string[9];ch2=string[10];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "%c%c", ch, ch2);
		}
		else
		{
           	printf("Error (orm). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "call", 4) == 0)
     {
		i=i+5;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "0e%c%c", ch, ch2);
           	ch=string[10];ch2=string[11];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "%c%c", ch, ch2);
		}
		else
		{
           	printf("Error (call). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "braz", 4) == 0)
     {
		i=i+5;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "10%c%c", ch, ch2);
           	ch=string[10];ch2=string[11];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "%c%c", ch, ch2);
		}
		else
		{
           	printf("Error (braz). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "bra", 3) == 0)
     {
		i=i+3;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "0f%c%c", ch, ch2);
           	ch=string[9];ch2=string[10];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "%c%c", ch, ch2);
		}
		else
		{
           	printf("Error (bra). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "reti", 4) == 0)
     {
            fprintf(fp2, "12");
     }
     else if(strncmp(&string[i], "ret", 3) == 0)
     {
             fprintf(fp2, "11");
     }
     else if(strncmp(&string[i], "iorecv", 6) == 0)
     {
		i=i+6;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
            fprintf(fp2, "13");
			ver(&ch,&ch2,line);
            fprintf(fp2, "%c%c", ch, ch2);
		}
		else
		{
            printf("Error (iorecv). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "iosend", 6) == 0)
     {
		i=i+6;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "14");
			ver(&ch,&ch2,line);
           	fprintf(fp2, "%c%c", ch, ch2);
		}
		else
		{
           	printf("Error (iosend). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "setie", 5) == 0)
     {
		i=i+5;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "15%c%c", ch, ch2);
		}
		else
		{
           	printf("Error (setie). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "ti0", 3) == 0)
     {
		i=i+3;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "16%c%c", ch, ch2);
           	ch=string[9];ch2=string[10];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "%c%c", ch, ch2);
		}
		else
		{
           	printf("Error (ti0). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
     else if(strncmp(&string[i], "ti1", 3) == 0)
     {
		i=i+3;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
           	fprintf(fp2, "17%c%c", ch, ch2);
           	ch=string[9];ch2=string[10];
			ver(&ch,&ch2,line);
          	fprintf(fp2, "%c%c", ch, ch2);
		}
		else
		{
           	printf("Error (ti1). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
    }
	else if(strncmp(&string[i], "dc", 2) == 0)
	{
		i=i+2;
		while(string[i] == '\t' || string[i] == ' ')
			i++;
		if(string[i+1] == 'x' && string[i] == '0')
		{
			ch=string[i+2];ch2=string[i+3];
			ver(&ch,&ch2,line);
            fprintf(fp2, "%c%c", ch, ch2);
		}
		else
		{
            printf("Error (dc). Not a hex arguement near line %i.\nBe sure there are only tabs (no spaces).", line+1);
			exit(1);
		}
     }
    else if((strncmp(&string[i], "equ", 3) == 0) || org==1 ||
		(strncmp(&string[i], "\n", 1) == 0) || string[i] == ';')
    {
                /* do nothing */
    }
    else
    {
                printf("Error: instruction not recognized in line %i\n", line+1);
                exit(1);
    }

 	/* If for whatever reason we reach an eof then break */
	if(feof(fp4))
		break;
    line++;
 }

 /* Put a semi-colon to tell loader this is end of file */
 fprintf(fp2, ";");
 fprintf(fp2, "\n");

 /* Close the files */
 if(fclose(fp) != 0)
        puts("Couldn't close source file");
 if(fclose(fp2) != 0)
        puts("Couldn't close destination file");

 if( verbose(argc, argv) )
 {
	printf("done\n");
	printf("output file written\n");
	printf("Removing temp files........");
 }


 /* Remove temp files unless there is a -d flag */
 if( !del(argc, argv) )
 {
 	if(remove("arb.tmp") != 0)
	{
		perror("Error removing arb.tmp");
	}
 	if(remove("arb.map") != 0)
	{
		perror("Error removing arb.map");
	}
 }



 if( verbose(argc, argv) )
 {
	printf("done\n");
 }


 return 0;

}
