// This is the control logic for the Arbadell computer
// Author: Shane Avery
// Date: October 26, 2001 (2001 was a great movie)
// Revised: November 6, 2001
// Further Revised: November 15, 2001
// Location: My testicle ....oops I mean cubicle
// Even Further Revised: August 14, 2002

module CONTROL ( ir,data,int0,int1,rst,ack,z,inc,ld3,
        ld0,s0,oe,ioaddr,rw,s1,ld1,aluop,ld2,
        pop,push,s2,addr,clk,ld4,wake,loaded,load,highz,state);

	input   rst,ack,z,clk;
   input   [7:0] ir;
   input   [7:0] data;
   input   int0,int1;
	input   loaded,load;

   output  inc,ld3,ld0,s0,oe,ioaddr,rw,s1;
   output  ld1,ld2,pop,push,s2,ld4,wake,highz;
   output  [2:0] aluop;
   output  [15:0] addr;
   output  [6:0] state;

   reg     [6:0] state;
   reg     [2:0] aluop;
   reg     [15:0] addr;
   reg     [7:0] first;
   reg     intbit,ie0,ie1;
	reg     inc,ld3,ld0,s0,oe,ioaddr,rw,s1;
   reg     ld1,ld2,pop,push,s2,ld4,wake,highz;

	

	always@(posedge clk or posedge rst) begin
		if(rst) begin
			state<=0;rw<=1'b1;oe<=1'bz;wake<=1;ioaddr<=0;inc<=0;ld3<=0;
			ld0<=0;s0<=0;s1<=0;ld1<=0;ld2<=0;pop<=0;push<=0;highz<=0;
			s2<=0;ld4<=0;intbit<=0;ie0<=0;ie1<=0;first<=0;addr<=0;
		end
		else begin
			case(state)
				0: begin
					if(load==1 && loaded==1) begin
						state<=0;wake<=0;rw<=1'bz;
						end
					else begin
						state<=1;rw<=1;oe<=0;highz<=1;
						end
					
				end

				1: begin
					highz<=0;
					if(intbit==0 && ((int0==1 && ie0==1) || (int1==1 && ie1==1)))
 				   	state<=62;
					else begin
						state<=2;ld0<=1;
					end
				end

				2: begin
					ld0<=0;state<=3;
				end

				3: begin
					inc<=1;
					if(ir==1 || ir==2 || ir==15 || ir==16 || ir==11 || ir==12 || ir==13 || ir==14 || ir==22 || ir==23 || ir==20 || ir==19)
						state<=8;
					else if(ir==3 || ir==4 || ir==5 || ir==6 || ir==7 || ir==8 || ir==9 || ir==10)
						state<=33;
					else if(ir==17)
						state<=51;
					else if(ir==18)
						state<=52;
					else if(ir==21)
						state<=53;
					else
						state<=4;
				end

				4: begin
					inc<=0;state<=5;
				end

				5: begin
					ld1<=1;state<=6;
				end

				6: begin
					s2<=0;state<=7;ld1<=0;
					if(ir==8'h12)
						inc<=0;
					else
						inc<=1;
				end

				7: begin
					inc<=0;state<=1;
				end

				8: begin
					inc<=0;state<=9;
				end

				9: begin
					if(ir==20 || ir==19)
						state<=92;
					else
						state<=10;
				end

				10: begin
					inc<=1;state<=11;first<=data;
				end

				11: begin
					inc<=0;
					if(ir==15 || ir==16)
						state<=46;
					else if(ir==22)
						state<=56;
					else if(ir==23)
						state<=59;
					else
						state<=12;
				end

				12: begin
					push<=1;state<=13;
				end

				13: begin
					push<=0;addr<={first,data};
					if(ir==2)
						state<=14;
					else if(ir==14)
						state<=85;
					else
						state<=25;
				end

				14: begin
					ld3<=1;oe<=1;state<=15;
				end

				15: begin
					ld3<=0;state<=16;s0<=1;
				end

				16: begin
					state<=17;rw<=0;
				end

				17: begin
					rw<=1;state<=18;
				end

				18: begin
					state<=19;
				end

				19: begin
					s0<=0;pop<=1;state<=20;
				end

				20: begin
					oe<=0;pop<=0;state<=21;
				end

				21: begin
					s2<=1;state<=22;
				end

				22: begin
					state<=23;
				end

				23: begin
					ld3<=1;state<=24;
				end

				24: begin
					ld3<=0;state<=6;
				end

				25: begin	
					ld3<=1;state<=26;
				end

				26: begin
					ld3<=0;
					if(ir==11 || ir==12 || ir==13)
						state<=39;
					else
						state<=27;
				end

				27: begin
					ld1<=1;state<=28;
				end

				28: begin
					pop<=1;state<=29;ld1<=0;
				end

				29: begin
					pop<=0;state<=30;
				end

				30: begin
					s2<=1;state<=31;
				end

				31: begin
					ld3<=1;state<=32;
				end

				32: begin
					ld3<=0;state<=6;
				end

				33: begin
					inc<=0;ld4<=1;state<=34;
					if(ir==8)
						aluop<=0;
					else if(ir==9)
						aluop<=1;
					else if(ir==10)
						aluop<=2;
					else
						aluop<=ir;
				end

				34: begin
					ld4<=0;state<=35;
				end

				35: begin
					s1<=1;state<=36;
				end

				36: begin
					ld2<=1;ld1<=1;state<=37;
				end

				37: begin
					ld1<=0;state<=38;ld2<=0;
				end

				38: begin
					s1<=0;
					if(ir==8 || ir==9 || ir==10)
						state<=6;
					else
						state<=1;
				end

				39: begin
					ld4<=1;state<=40;
					if(ir==11)
						aluop<=0;
					else if(ir==12)
						aluop<=1;
					else
						aluop<=2;
				end

				40: begin
					ld4<=0;state<=41;
				end

				41: begin
					s1<=1;state<=42;pop<=1;
				end

				42: begin
					ld2<=1;ld1<=1;pop<=0;s2<=1;state<=43;
				end

				43: begin
					ld1<=0;s2<=1;ld3<=1;state<=44;ld2<=0;
				end

				44: begin
					s1<=0;ld3<=0;state<=45;
				end

				45: begin
					s2<=0;state<=6;
				end

				46: begin
					state<=83;
				end

				83: begin
					addr<={first,data};state<=84;
				end

				84: begin
					if(ir==16)
						state<=49;
					else
						state<=47;
				end

				47: begin
					ld3<=1;state<=48;
				end

				48: begin
					ld3<=0;state<=1;
				end

				49: begin
					if(z==1) begin
						ld3<=1;state<=50;
					end
					else
						state<=6;
				end

				50: begin
					state<=1;ld3<=0;
				end

				85: begin
					state<=86;
				end

				86: begin
					ld3<=1;state<=50;
				end

				51: begin
					inc<=0;pop<=1;state<=20;
				end

				52: begin
					inc<=0;pop<=1;intbit<=0;state<=20;
				end

				53: begin
					inc<=0;state<=54;
				end

				54: begin
					state<=55;
				end

				55: begin
					state<=6;ie0<=data[0];ie1<=data[1];
				end

				56: begin
					if(int0==1)
						state<=87;
					else
						state<=6;
				end

				87: begin
					state<=88;addr<={first,data};
				end

				88: begin
					state<=57;
				end

				57: begin
					ld3<=1;state<=58;
				end

				58: begin
					ld3<=0;state<=1;
				end

				59: begin
					if(int1==1)
						state<=89;
					else
						state<=6;
				end

				89: begin
					state<=90;addr<={first,data};
				end

				90: begin
					state<=60;
				end

				60: begin
					ld3<=1;state<=61;
				end

				61: begin
					state<=1;ld3<=0;
				end

				62: begin
					push<=1;state<=63;
				end

				63: begin
					push<=0;intbit<=1;
					if(int0==1)
						state<=64;
					else
						state<=65;
				end

				64: begin
					addr<=16'hfff0;state<=66;
				end

				65: begin
					addr<=16'hfff8;state<=66;
				end

				66: begin
					state<=67;
				end

				67: begin
					ld3<=1;state<=91;
				end

				91: begin
					ld3<=0;state<=1;
				end

				92: begin
					state<=68;first<=data;
				end

				68: begin
					push<=1;state<=69;
				end

				69: begin
					push<=0;addr<={8'h0,data};state<=93;
				end

				93: begin
					state<=70;
				end

				70: begin
					ld3<=1;oe<=1;
					if(ir==20)
						state<=71;
					else
						state<=79;
				end

				71: begin
					if(ack==1)
						state<=71;
					else begin
						ld3<=0;s0<=1;state<=72;
					end
				end

				72: begin
					ioaddr<=1;
					if(ack==0)
						state<=72;
				  	else
						state<=73;
				end

				73: begin
					s0<=0;ioaddr<=0;s2<=1;state<=74;
				end

				74: begin
					oe<=0;pop<=1;state<=75;
				end

				75: begin
					pop<=0;state<=76;
				end

				76: begin
					state<=77;
				end

				77: begin
					ld3<=1;state<=78;
				end

				78: begin
					s2<=0;state<=6;ld3<=0;
				end

				79: begin
					if(ack==1)
						state<=79;
					else begin
						ld3<=0;state<=80;
					end
				end

				80: begin
					ioaddr<=1;
					if(ack==0)
						state<=80;
					else
						state<=81;
				end

				81: begin
					ld1<=1;state<=82;
				end

				82: begin
					ld1<=0;ioaddr<=0;state<=73;
				end
			endcase
		end
	end

endmodule
