

module testbench();

// DATE:     Tue Aug 13 15:34:31 2002 
// TITLE:    
// MODULE:   ALU
// DESIGN:   ALU
// FILENAME: alu
// PROJECT:  cpu
// VERSION:  Version


// Inputs
    reg [7:0] data;
    reg [7:0] sc_reg;
    reg [2:0] op;
    reg clk;
    reg rst;


// Outputs
    wire [7:0] out;
    wire z;


// Bidirs


// Instantiate the UUT
    ALU d (
        .data(data), 
        .sc_reg(sc_reg), 
        .op(op), 
        .clk(clk), 
        .rst(rst), 
        .out(out), 
        .z(z)
        );


// Initialize Inputs
    `ifdef auto_init

        initial begin
            data = 0;
            sc_reg = 0;
            op = 0;
            clk = 0;
            rst = 0;
        end

    `endif

	 always begin
	 	forever begin
	 		#1 clk=0;
			#1 clk=1;
	 	end
	 end

	 always begin
	 	forever
	 	#30 op=op+1;
	 end

	 initial begin
	 	rst=0;op=0;data=8'h5f;sc_reg=8'h63;clk=0;
		#30 rst=1;
		#300 $stop;
	 end

endmodule

