// This is the verilog implementation of the ALU for the Arbadell
// Written by: Shane Avery (who worked hard even though his girl is mad, yes still)
// Date: July 31, 2001
// Location: Bedroom. 25 Los Verdes. All alone.
// Revised: August 13, 2002
// Made the code synchronous. This made the code cleaner and easier to read

module ALU(data, sc_reg, op, out, z, clk, rst);
	input  [7:0] data;
	input  [7:0] sc_reg;
	input  [2:0] op;
	input  clk,rst;

	output [7:0] out;
	output z;
	
	reg    [7:0] out;
	reg	 z;

	always@(posedge clk or posedge rst) begin
		if(rst)
			out<=0;
		else begin
			case(op)
				0: out<=sc_reg+data;
				1: out<=sc_reg&data;
				2: out<=sc_reg|data;
				3: out<=~sc_reg;
				4: out<=sc_reg+1;
				5: out<=sc_reg-1;
				6: out<=sc_reg >> 1;
				7: out<=sc_reg << 1;
			endcase
		end
	end

	always@(posedge clk or posedge rst) begin
		if(rst)
			z<=0;
		else if(out==0)
			z<=1;
		else
			z<=0;
	end

endmodule

