// This is the top level module that glues the whole design together
// Author: Shane Avery
// Date: November 15, 2001
// Location: Bedroom. 25 Los Verdes. Done. FINALLY. I'm getting drunk
// Revised: August 14, 2002
module cpu(address,int0,int1,oe,reset,ack,ioaddr,rw,data,clk,wake,loaded,load,state);

	input   reset,ack,clk;
	input   int0,int1,loaded,load;

   output  ioaddr,rw,oe,wake;
   output  [15:0] address;
   output  [6:0] state;
   inout   [7:0] data;

	wire 	  push,pop,ld0,ld1,ld2,ld3,ld4,inc,z_alu,s1,s2,s0,highz;
	wire	  [15:0] stack_out,pc_in,cont_address;
	wire    [7:0] d_scin,d_scout,ir_out,alu_in,alu_out,d_cont;
	wire 	  [2:0] aluop;

	reg 	  z_cont;
      
   wire rst;
   assign rst=~reset;
   STARTUP U1(.GSR(rst));   
      
   STACK stack1(address,push,pop,rst,stack_out,clk);
   PC_REG pc_reg1(pc_in,ld3,inc,address,clk,rst,highz);
   REG1 sc_reg(d_scin,ld1,d_scout,clk,rst);
   REG1 ir_reg(data,ld0,ir_out,clk,rst);
	REG1 sc_reg_hold(d_scout,ld4,alu_in,clk,rst);
   ALU alu1(d_cont,alu_in,aluop,alu_out,z_alu,clk,rst);
   Mux8 mux8_1(d_cont,alu_out,s1,d_scin,clk,rst);
   Mux16 mux16_1(cont_address,stack_out,s2,pc_in,clk,rst);
   Muxsp muxsp_1(d_cont,d_scout,s0,data);
   CONTROL contl(ir_out,d_cont,int0,int1,rst,ack,z_cont,inc,ld3,
        			  ld0,s0,oe,ioaddr,rw,s1,ld1,aluop,ld2,
        			  pop,push,s2,cont_address,clk,ld4,
					  wake,loaded,load,highz,state);  
     
	always@(posedge clk or posedge rst) begin
		if(rst)
			z_cont<=0;
		else if(ld2==1)
			z_cont<=z_alu;
	end

endmodule
