

module testbench();

// DATE:     Wed Aug 14 14:11:44 2002 
// TITLE:    
// MODULE:   cpu
// DESIGN:   cpu
// FILENAME: cpu
// PROJECT:  cpu
// VERSION:  Version


// Inputs
    reg rst;
    reg ack;
    reg clk;
    reg int0;
    reg int1;
    reg loaded;
    reg load;


// Outputs
    wire ioaddr;
    wire rw;
    wire oe;
    wire wake;
    wire [15:0] address;


// Bidirs
    wire [7:0] data;

	 reg  [7:0] data_in;
	 assign data=data_in;


// Instantiate the UUT
    cpu d (
        .rst(rst), 
        .ack(ack), 
        .clk(clk), 
        .int0(int0), 
        .int1(int1), 
        .loaded(loaded), 
        .load(load), 
        .ioaddr(ioaddr), 
        .rw(rw), 
        .oe(oe), 
        .wake(wake), 
        .address(address), 
        .data(data)
        );


// Initialize Inputs
    `ifdef auto_init

        initial begin
            rst = 0;
            ack = 0;
            clk = 0;
            int0 = 0;
            int1 = 0;
            loaded = 0;
            load = 0;
        end

    `endif

	 initial begin
	 clk=0;
	 end

	 always begin
	 	forever begin
			#1 clk=0;
			#1 clk=1;
		end
	 end

	 initial begin
	 	rst=0;load=1;loaded=1;data_in=0;ack=0;int0=0;int1=0;
		// Test the reset and the load process
		#20 rst=1;
		#30 loaded=0;

		// Test movel
		#30 data_in=8'hfe;

		// Test moves
		#6  data_in=2;
		#8  data_in=8'h69;
		#6  data_in=8'h57;
		#6  data_in=8'hzz;
		#12 data_in=8'h57;

		// Test movem
		#12 data_in=1;
		#8  data_in=8'h35;
		#6  data_in=8'hcb;
		#8	 data_in=8'h1a;

		// Test the alu operations (not memory)
		#16 data_in=3;
		#8  data_in=8;
		#18 data_in=8'h20;

		// Test alu operations (memory)
		#14 data_in=12;
		#8  data_in=8'h55;
		#6  data_in=8'hcb;
		#8  data_in=0;

		// Test braz (this was tested with data_in=8'hff and is worked great)
		#18 data_in=16;
		#8  data_in=8'h19;
		#6  data_in=8'h7d;

		// Test bra
		#10 data_in=15;
		#8  data_in=8'h27;
		#6  data_in=8'h5d;

		// Test call
		#10 data_in=14;
		#8  data_in=8'h99;
		#6  data_in=8'hab;

		// Test return
		#10 data_in=17;

		// Test ti0
		#22 data_in=8'h16;
		#8  data_in=8'h49;
		#6  data_in=8'h50;

		#4  int0=1;
		#2	 data_in=8'h16;
		#8  data_in=8'h78;
		#6  data_in=8'hfa;int0=0;

		// Test setie
		#6  data_in=8'h15;
		#8  data_in=1;int0=1;int1=1;

		// Test interrupts
		#8  data_in=0;

		// Test reti
		#14 data_in=8'h12;int0=0;int1=0;

		// Test iosend
		#18 data_in=8'h14;
		#12 data_in=8'h03;
		#12 data_in=8'hzz;
		#6  ack=1;
		#6  ack=0;data_in=8'hff;

		// Test iorecv
		#12 data_in=8'h13;
		#8  data_in=2;
		#18 ack=1;
		#8  ack=0;

		#50 $stop;


	 end

endmodule

