// This is the verilog implementation of the PC Register
// for the Arbadell computer
// Written by: Shane Avery (girlfriend kisses GOOD)
// Date: July 7, 2001
// Location: Bedroom. 25 Los Verdes. Listening to Van Halen.
// Revised: August 13, 2002
// Cleaned up the <= and added a reset

module PC_REG(in, load, inc, out, clk, rst, highz);
	input  [15:0] in;
	input  clk,inc,load,rst,highz;

	output [15:0] out;
	reg    [15:0] out;

	always@(posedge clk or posedge rst) begin
		if(rst)
			out<=16'hzzzz;
		else if(highz == 1)
			out<=0;
		else if(load == 1)
			out<=in;
		else if(inc == 1)
			out<=out+1;
	end
endmodule
