// This is the verilog implementation of the STACK for the Arbadell
// Written by: Shane Avery (girlfriend likes to frustrate me)
// Date: July 7, 2001
// Revised: November 6, 2001
// Location: Bedroom. 25 Los Verdes. I'm going fishing. I farted. 
// Revised: August 13, 2002
// Cleaned up the code. Used case statements and added state machine for counter

module STACK(in, push, pop, rst, out, clk);
	input  [15:0] in;
	input  push,pop,rst,clk;

	output [15:0] out;
	reg    [15:0] out;
   reg    [15:0] store [7:0];
	reg    [3:0]  counter;

	always@(posedge clk or posedge rst) begin
		if(rst) begin
      	store[0]<=0;store[1]<=0;store[2]<=0;store[3]<=0;
         store[4]<=0;store[5]<=0;store[6]<=0;store[7]<=0;
         out<=0;
		end
		else if(push == 1) begin
			case(counter)
				0: store[0]<=in;
				1: store[1]<=in;
				2: store[2]<=in;
				3: store[3]<=in;
				4: store[4]<=in;
				5: store[5]<=in;
				6: store[6]<=in;
				7: store[7]<=in;
			endcase
      end
		else if(pop == 1) begin
			case(counter)
				0: out<=0;
				1: out<=store[0];
				2: out<=store[1];
				3: out<=store[2];
				4: out<=store[3];
				5: out<=store[4];
				6: out<=store[5];
				7: out<=store[6];
				8: out<=store[7];
			endcase
 		end
	end

	reg [1:0] state;
	always@(posedge clk or posedge rst) begin
		if(rst) begin
			counter<=0;state<=0;
		end
		else begin
			case(state)
				0: begin
					if(pop==1)
						state<=2;
					else if(push==1)
						state<=1;
				end

				1: begin
					counter<=counter+1;
					state<=3;
				end

				2: begin
					counter<=counter-1;
					state<=3;
				end

				3: begin
					state<=0;
				end
			endcase
		end
	end
endmodule


