

module testbench();

// DATE:     Tue Aug 13 16:43:26 2002 
// TITLE:    
// MODULE:   STACK
// DESIGN:   STACK
// FILENAME: stack
// PROJECT:  cpu
// VERSION:  Version


// Inputs
    reg [15:0] in;
    reg push;
    reg pop;
    reg rst;
    reg clk;


// Outputs
    wire [15:0] out;


// Bidirs


// Instantiate the UUT
    STACK d (
        .in(in), 
        .push(push), 
        .pop(pop), 
        .rst(rst), 
        .clk(clk), 
        .out(out)
        );


// Initialize Inputs
    `ifdef auto_init

        initial begin
            in = 0;
            push = 0;
            pop = 0;
            rst = 0;
            clk = 0;
        end

    `endif
	
	 initial 
	 	clk=0;

	 always begin
	 	forever begin
			#1 clk=0;
			#1 clk=1;
		end
	 end

	 initial begin
	 	rst=0;pop=0;push=0;in=16'h1234;
		#30 rst=1;
		#30 push=1;
		#2  push=0;
		#10 in=16'h5678;
		#20 push=1;
		#2  push=0;
		#10 in=16'h9abc;
		#20 push=1;
		#2  push=0;
		#10 in=16'hdef0;
		#20 pop=1;
		#2  pop=0;
		#30 pop=1;
		#2	 pop=0;
		#30 push=1;
		#2	 push=0;
		#30 pop=1;
		#2  pop=0;
		#30 pop=1;
		#2  pop=0;
		#30 $stop;
	 end

endmodule

