; This is code the AVR8515 that will load the RAM for the Arbadell computer
; PortA is the data port
; PortB is low adress port
; PortC is the high address port
; PortD bit2 is CE, bit3 is oe, bit4 is we, bit0=rx bit1=tx for serial
; Written by: Shane Avery
; Date: November 30, 2001
; Modified: October 18, 2002
; load signal on PortD bit2 and done signal on PortD bit7

	.include "c:\arbadell\loader\8515def.inc"
	
	rjmp	start
	rjmp	int
	rjmp	int
	rjmp	int
	rjmp	int
	rjmp	int
	rjmp	int
	rjmp	int
	rjmp	int
	
	rjmp	recv
	rjmp	empty
	rjmp	tx
	
	rjmp	int
	
int:
	reti
	
recv:
	in	r18,UDR		;grab the serial byte
	ldi	r20,0x01	;set bit one in r20 to tell loop that there is a new byte in r18
	reti
	
empty:
	reti
	
tx:
	reti
	
start:
	in	r16,PIND	;read bit2 of portD and branch
	sbrc	r16,2		;when it is clear
	rjmp	start
	
	clr	r16		;clear registers
	clr	r17		;send byte
	clr	r18		;value from serial port
	clr	r19
	clr	r20		;receive flag
	clr	r21		;store ASCII serial byte1
	clr	r22		;store ASCII serial byte2
	clr	r23		;convert byte
	clr	r24

	clr	r25		;address high
	clr	r26		;address low
	clr	r27		;data
	
	clr	r28		;semicolon flag
	clr	r29		;colon flag
	clr	r0		;byte counter for new lines during a read
	
	clr	r1		;storage for RAM addresses and data
	clr	r2
	clr	r3
	clr	r4
	
	clr	r5		;address bytes for the file writes
	clr	r6

	ldi 	r16,0x02	;Stack Pointer Setup 
	sts 	0x5e,r16	;Stack Pointer High Byte 
	ldi 	r16,0x5f       	;Stack Pointer Setup
	sts 	0x5d,r16	;Stack Pointer Low Byte 
	
	ldi 	r16,0x80	; 
	out 	0x08,r16	;Comparator Disabled to save power
	
	ldi	r16,0xff	;make portb and portc output and put all 0s on it
	out	DDRB,r16
	out	DDRC,r16
	ldi	r16,0x00
	out	PORTB,r16
	out	PORTC,r16
	
	ldi	r16,0x18	;CE but not WE or OE
	out	PORTD,r16
	ldi	r16,0x78	;make all but bits0,1,2,7 of portd output
	out	DDRD,r16	;bits 1,0 are used for serial communication
	
	ldi	r16,0x98	;enable send, receive, and receive interrupt
	out	UCR,r16
	sei
	
	ldi	r16,0x0b	;set baud to 9600
	out	UBRR,r16
	
cmd:	ldi	r18,0x00	;clears the value of most recent serial input
	clr	r28
	clr	r29
	ldi	r17,0x0d	;send command prompt to screen
	rcall	send
	ldi	r17,0x0a
	rcall	send	
	ldi	r17,0x63	
	rcall	send 
	ldi	r17,0x6d
	rcall	send
	ldi	r17,0x64
	rcall	send
	ldi	r17,0x3e
	rcall	send

cmd1:	ldi	r19,0x6c	;type a 'r' to read and a 'l' to load a file 
	cp	r18,r19		;or 'f' to fill or a 'd' for done
	breq	sendf
	ldi	r19,0x72
	cp	r18,r19
	breq	readf
	ldi	r19,0x66
	cp	r18,r19
	breq	fill
	ldi	r19,0x64
	cp	r18,r19
	breq	done
	rjmp	cmd1
	
readf:	clr 	r20		;if the command was a read then we get to here
	rjmp	read1
	
fill:	clr	r20
	rjmp	fill1
		
;*************************************************************
; This portion will receive bytes from the serial port and 
; put them into RAM
;*************************************************************	
sendf:	clr	r20		;if the command was a load
	
	ldi	r17,0x0d	;display "send file:" to screen
	rcall	send
	ldi	r17,0x0a
	rcall	send	
	ldi	r17,0x73
	rcall	send
	ldi	r17,0x65
	rcall	send
	ldi	r17,0x6e
	rcall	send
	ldi	r17,0x64
	rcall	send
	ldi	r17,0x20	
	rcall	send
	ldi	r17,0x66
	rcall	send
	ldi	r17,0x69
	rcall	send
	ldi	r17,0x6c
	rcall	send
	ldi	r17,0x65	
	rcall	send
	ldi	r17,0x3a
	rcall	send

tester:
	ldi	r18,0x00	;clear the value of serial input
	ldi	r20,0x00	;clear the receive flag
	ldi	r28,0x00	;clear the semicolon flag
	
getnext:
	clr	r29		;clear the colon flag	
	rcall	getbytef
	ldi	r16,0x01
	cp	r16,r28
	breq	goCMD
	cp	r16,r29
	breq	getnext
	rcall	convert
	rjmp	WRAM
	
goCMD:	rjmp	cmd	
	
	;Now write that value to RAM
WRAM:	mov	r16,r5		;retrieve address values and put them
	out	PORTC,r16	;on portb and portc
	mov	r16,r6
	out	PORTB,r16
	ldi	r16,0xff
	out	DDRA,r16	;make porta output and put data value on it
	mov	r16,r21
	out	PORTA,r16
	
	ldi	r16,0x08	;this should write the RAM
	out	PORTD,r16	
	ldi	r16,0x18
	out	PORTD,r16	;now raise WE (write should be complete)
	
	ldi	r16,0x00
	out	DDRA,r16	;make porta input and clear porta reg
	out	PORTA,r16
	
	inc	r6		;increment the address
	breq	incr5
	rjmp	getnext
incr5:	inc	r5
	rjmp	getnext

;*************************************************************
; This portion will send a signal to the CPU indicating
; that the RAM is loaded
;*************************************************************
done:	ldi	r16,0x00	;make all busses input so there is no 
	out	DDRB,r16	;conflictions
	out	DDRC,r16
	out	DDRA,r16
	ldi	r16,0x80	;make bit7 output
	out	DDRD,r16	;bits 1,0 are used for serial communication
	ldi	r16,0x00	;output logic 0 on bit7 to tell cpu RAM loaded
	out	PORTD,r16
	
l4ever:	rjmp	l4ever		;loop forever

;***********************************************************
; This portion will read the values of a range of adresses
; and output their values to the serial port
;***********************************************************
read1:
	ldi	r17,0x0d	;display "range:" to screen
	rcall	send
	ldi	r17,0x0a
	rcall	send	
	ldi	r17,0x72
	rcall	send
	ldi	r17,0x61
	rcall	send
	ldi	r17,0x6e
	rcall	send
	ldi	r17,0x67
	rcall	send
	ldi	r17,0x65	
	rcall	send
	ldi	r17,0x3a
	rcall	send
	
;Get the two bytes that represent what address to read from	
	rcall	getbyte
	rcall	convert
	mov	r1,r21
	rcall	getbyte
	rcall	convert
	mov	r2,r21
	rcall	getbyte
	rcall	convert
	mov	r3,r21
	rcall	getbyte
	rcall	convert
	mov	r4,r21	
	
	ldi	r17,0x0d	;send new line and line feed
	rcall	send
	ldi	r17,0x0a
	rcall	send	
	
	clr	r0		;r0 counts the number of bytes for new lines

contread:	
	cp	r3,r1
	brsh	valid

alldone:		
	rjmp	cmd
	
valid:
	cp	r4,r2
	brsh	valid2
	rjmp	alldone	

valid2:
	mov	r16,r2		;put the address on the ports
	out	PORTB,r16
	mov	r16,r1
	out	PORTC,r16
	
	ldi	r16,0x10	;enable the RAM output
	out	PORTD,r16	
	nop			;wait for data to appear
	in	r23,PINA
	ldi	r16,0x18
	out	PORTD,r16	;disable output
	rcall	convert2	;send data grabbed to serial port
	
	ldi	r17,0x20	;send a space
	rcall	send	
	
	inc	r0
	ldi	r16,0x10
	cp	r0,r16
	breq	sendnllf
	rjmp 	incr2

sendnllf:
	clr	r0
	ldi	r17,0x0d	;send new line and line feed
	rcall	send
	ldi	r17,0x0a
	rcall	send	
	
incr2:
	inc	r2
	breq	incr1
	rjmp	contread
	
incr1:	inc	r1
	rjmp	contread	


;***********************************************************
; This portion will fill RAM with one byte at the specified
; address with the specified value
;***********************************************************
fill1:
	ldi	r17,0x0d	;display "addr & value:" to screen
	rcall	send
	ldi	r17,0x0a
	rcall	send	
	ldi	r17,0x61
	rcall	send
	ldi	r17,0x64
	rcall	send
	ldi	r17,0x64
	rcall	send
	ldi	r17,0x72
	rcall	send
	ldi	r17,0x20	
	rcall	send
	ldi	r17,0x26
	rcall	send
	ldi	r17,0x20
	rcall	send
	ldi	r17,0x76
	rcall	send
	ldi	r17,0x61
	rcall	send
	ldi	r17,0x6c
	rcall	send
	ldi	r17,0x75	
	rcall	send
	ldi	r17,0x65
	rcall	send
	ldi	r17,0x3a
	rcall	send

;This will grab the first byte of address to be filled in RAM	
	rcall	getbyte

;Now that address has been grabbed convert it and store it	
	rcall	convert
	mov	r1,r21

;Now grab the second byte of the address
	rcall	getbyte

;Now that 2nd bytes has been grabbeed convert it and store it
	rcall	convert
	mov	r2,r21

;Now grab the second byte of the address
	rcall	getbyte

;Covert it and store it
	rcall	convert
	mov	r3,r21
		
;Now write that value to RAM
	mov	r16,r1		;retrieve address values and put them
	out	PORTC,r16	;on portb and portc
	mov	r16,r2
	out	PORTB,r16
	ldi	r16,0xff
	out	DDRA,r16	;make porta output and put data value on it
	mov	r16,r3
	out	PORTA,r16
	
	ldi	r16,0x08	;this should write the RAM
	out	PORTD,r16	
	ldi	r16,0x18
	out	PORTD,r16	;now raise WE (write should be complete)
	
	ldi	r16,0x00
	out	DDRA,r16	;make porta input and clear porta reg
	out	PORTA,r16
	
	rjmp 	cmd
;**************************************************************************	
; This is a fucntion that will send the byte in r17 out the serial port	
;**************************************************************************
send:
	out	UDR,r17
	nop
swait:	sbis	USR,5
	rjmp	swait
	
	ret
	
;**************************************************************************	
; This is a fucntion that will convert the bytes in r21 and r22 from 
; ASCII to a real hex number it represents and store it in r21	
;**************************************************************************
convert:
	ldi	r16,0x3a
	cp	r21,r16
	brlo	testd
	rjmp	testa
	
testd:	ldi	r16,0x30
	cp	r21,r16
	brge	decimal
	rjmp	finish

decimal:
	andi	r21,0x0f
	rjmp	secondb

testa:	ldi	r16,0x67
	cp	r21,r16
	brlo	testa2
	rjmp	finish
	
testa2:	ldi	r16,0x61
	cp	r21,r16
	brge	alpha
	rjmp	finish
	
alpha:	andi	r21,0x0f
	ldi	r16,0x09
	add	r21,r16
	
secondb:	
	ldi	r16,0x3a
	cp	r22,r16
	brlo	testd2
	rjmp	testa2b
	
testd2:	ldi	r16,0x30
	cp	r22,r16
	brge	decimal2
	rjmp	finish

decimal2:
	andi	r22,0x0f
	rjmp	combine

testa2b:	
	ldi	r16,0x67
	cp	r22,r16
	brlo	testa22
	rjmp	finish
	
testa22:	
	ldi	r16,0x61
	cp	r22,r16
	brge	alpha2
	rjmp	finish
	
alpha2:	andi	r22,0x0f
	ldi	r16,0x09
	add	r22,r16	

combine:
	swap	r22
	or	r21,r22
	swap	r21

finish:
	ret

;**************************************************************************	
; This is a fucntion that will convert the byte in r23 to an ASCII value 
; and send it out the serial port	
;**************************************************************************	
convert2:
	mov	r24,r23		;copy the byte to be converted to r24
	andi	r24,0xf0	;mask out first nibble
	swap	r24		;swap so last nibble is first nibble
	ldi	r16,0x0a	;compare nibble to 0x0a 
	cp	r24,r16		
	brlo	outdec		;if it is lower then it is 0-9
	
	ldi	r16,0x57	;else it is a-f
	add	r24,r16		;add 0x37 to change the value to an ascii number
	mov	r17,r24		;send looks for byte in r17
	rcall	send		;send it out
	rjmp	second		;send the second nibble
	
outdec:	ldi	r16,0x30	;add 0x30 to the number to make it ascii
	add	r24,r16
	mov	r17,r24		;send looks for byte in r17			
	rcall	send		;send it out
	rjmp	second		;send out the second nibble

second:
	mov	r24,r23		;copy the byte to be converted to r24
	andi	r24,0x0f	;mask out first nibble
	ldi	r16,0x0a	;compare nibble to 0x0a 
	cp	r24,r16		
	brlo	outdec2		;if it is lower then it is 0-9
	
	ldi	r16,0x57	;else it is a-f
	add	r24,r16		;add 0x37 to change the value to an ascii number
	mov	r17,r24		;send looks for byte in r17
	rcall	send		;send it out
	rjmp	finish2
	
outdec2:	
	ldi	r16,0x30	;add 0x30 to the number to make it ascii
	add	r24,r16	
	mov	r17,r24		;send looks for byte in r17	
	rcall	send		;send it out

finish2:
	ret

;************************************************************
; This is a function that will grab two bytes from serial
; It stores the first in r21 and second in r22
;************************************************************
getbyte:
	ldi	r18,0x00	;clear the value of serial input
	ldi	r20,0x00	;clear the receive flag


waitb1: ldi	r19,0x01	;check to see if a byte has been entered
	cp	r19,r20
	breq	getb1		;if it has then break
	rjmp	waitb1
	
getb1:	mov	r21,r18
	ldi	r20,0x00	;clear the receive flag
	
waitb2: ldi	r19,0x01	;check to see if a byte has been entered
	cp	r19,r20
	breq	getb2		;if it has then break
	rjmp	waitb2
	
getb2:	mov	r22,r18
	ldi	r20,0x00	;clear the receive flag
	ldi	r18,0x00	;clear the value of serial input	
	
	ret
	
;************************************************************
; This is a function that will grab two bytes from serial
; It stores the first in r21 and second in r22
; It is a modified verision of above and will handle the 
; file inputs such as colons and semicolons
;************************************************************
getbytef:
	ldi	r18,0x00	;clear the value of serial input
	ldi	r20,0x00	;clear the receive flag


waitb1f: 
	ldi	r19,0x01	;check to see if a byte has been entered
	cp	r19,r20
	breq	getb1f		;if it has then break
	rjmp	waitb1f
	
getb1f:	mov	r21,r18
	ldi	r20,0x00	;clear the receive flag
	ldi	r19,0x3a	;check for colon
	cp	r21,r19
	breq	setaddr		;if colon then there is an address change
	ldi	r19,0x3b	;check for semi colon
	cp	r21,r19
	brne	waitb2f		;if semi colon then end of file
	ldi	r28,0x01
	rjmp	finish3	
	
waitb2f: 
	ldi	r19,0x01	;check to see if a byte has been entered
	cp	r19,r20
	breq	getb2f		;if it has then break
	rjmp	waitb2f
	
getb2f:	mov	r22,r18
	ldi	r20,0x00	;clear the receive flag
	ldi	r18,0x00	;clear the value of serial input
	rjmp	finish3
	
setaddr:
	ldi	r18,0x00	;clear the value of serial input
	ldi	r20,0x00	;clear the receive flag
	ldi	r29,0x01	;set colon flag
	clr	r5
	clr	r6


waita1: ldi	r19,0x01	;check to see if a byte has been entered
	cp	r19,r20
	breq	geta1		;if it has then break
	rjmp	waita1
	
geta1:	mov	r1,r18
	ldi	r20,0x00	;clear the receive flag
	
waita2: ldi	r19,0x01	;check to see if a byte has been entered
	cp	r19,r20
	breq	geta2		;if it has then break
	rjmp	waita2
	
geta2:	mov	r2,r18
	ldi	r20,0x00	;clear the receive flag
	ldi	r19,0x20	;check for space
	cp	r18,r19
	breq	addr1		;if colon then there is an address change
	
waita3: ldi	r19,0x01	;check to see if a byte has been entered
	cp	r19,r20
	breq	geta3		;if it has then break
	rjmp	waita3
	
geta3:	mov	r3,r18
	ldi	r20,0x00	;clear the receive flag
	ldi	r19,0x20	;check for space
	cp	r18,r19
	breq	addr2		;if colon then there is an address change
	
waita4: ldi	r19,0x01	;check to see if a byte has been entered
	cp	r19,r20
	breq	geta4		;if it has then break
	rjmp	waita4
	
geta4:	mov	r4,r18
	ldi	r20,0x00	;clear the receive flag
	ldi	r19,0x20	;check for space
	cp	r18,r19
	breq	addr3		;if colon then there is an address change

;If by four byte no space then the four we have is the address and
;we need to eat the space
waita5: ldi	r19,0x01	;check to see if a byte has been entered
	cp	r19,r20
	breq	addr4		;if it has then break
	rjmp	waita5

;Now update the address to be written to RAM
addr4:
	mov	r21,r1
	mov	r22,r2
	rcall	convert		;get first byte grabbed, convert it, store it
	mov	r5,r21
	mov	r21,r3
	mov	r22,r4
	rcall	convert		;same with second
	mov	r6,r21
	rjmp	finish3

addr2:
	mov	r21,r1		;get second byte and convert it, store it
	mov	r22,r2
	rcall	convert
	mov	r6,r21
	clr	r5		;clear first address byte
	rjmp	finish3
		
addr3:
	mov	r21,r2		;get second byte and convert it, store it
	mov	r22,r3
	rcall	convert
	mov	r6,r21
	mov	r21,r1
	clr	r22
	rcall	convert
	mov	r5,r21
	rjmp	finish

addr1:
	mov	r21,r1		;get second byte and convert it, store it
	clr	r22
	clr	r5
	rcall	convert
	mov	r6,r21
			
finish3:
	ret
