/*************************************************************
* This header file will provide the protoype function
* declarations of the IOFunctions.
*
* Written by: Shane Avery
**************************************************************/
#ifndef _IOFuncsHeader
#define _IOFuncsHeader

// This function is used to turn LEDs on. Simply pass in
// what LEDs we want on.
void LEDOn(unsigned int LEDs);

// This function is used to turn LEDs off. Simply pass in
// what LEDs we want on. 
void LEDOff(unsigned int LEDs);

// This function will use timer6 to wait for 100ms.
// It simply sets up timer6 and looks for the
// interrupt flag.
void Wait100ms();

// This function will write size bytes from the buffer starting
// at address to the EEPROM using I2C. It should noted that this
// is a page write and so no more than 64 bytes should be written
// at a time or else the data will be corrupted. We will first
// check to see if there is another I2C operation otherwize we
// will fill in some Global buffers and variables, start a transmit
// and let the ISR do the work. This will allow us to call this
// function and quickly return to the main loop. We only block
// if we do two writes in a row.
char WriteEEPROM(int address, char *buffer, unsigned char size);

// This function will read size bytes from the EEPROM using I2C
// starting at address and store the bytes in the buffer. Note
// that the EEPROM only allows for a page size of 64 bytes.
// Thus, we should never ask for a read bigger than that.
// We will first check to see if there is another I2C operation 
// otherwize we will fill in some Global buffers and variables, 
// start a recieve and let the ISR do the work. Unlike WriteEEPROM
// this will block until we are done with the operation. This is
// not that big of a deal because we will only do a read to dump
// the entire memory and everyone in the system should be stopped
// at that point anyway.
char ReadEEPROM(int address, char *buffer, unsigned char size);

// This function will write the ch byte to the
// Terminal/IRDA output.
void TIputc(char ch);

// This function writes a string to the Terminal/IRDA
// interface. String must NULL Terminate.
void TIputs(char *ptr);

// This function will get a byte from the Terminal/IRDA.
// NOTE: This function uses Timer1 just as TIPutc and
// LEDTest. Thus, none of those functions should be called
// from within this function.
char TIgetc();

// This function will simply block waiting until we have the mutex.
// We will set the WaitForMutex flag which will tell the RX ISR
// that we want the mutex. Otherwise the ISR would just pass the
// mutex on to the next node.
void GetMutex();

// This function will send the mutex to the next node. We will also clear
// the Mutex variable which tells our system that we currently have the mutex.
char ReleaseMutex();

// This function will write the TransData struct to the XB module.
// It will check to see that the module is ready to receive
// data. If not then we will return with a value of -1.
// We will also check to see if we are currently sending
// data to the XB module. If we are then we will return 
// a value of -1. A return value of -1 indicates that we 
// can't write the buffer right now and control loop should 
// try sometime later. 
//
// This function should be called when we are in the API
// mode. It make some assumptions about what the TransData
// struct looks like and thus if there is a change to the
// struct this function should be verified for functionality.
// What's nice about this function is that the main loop only
// needs to define the destination address and the data. The
// rest was defined in the init function and the checksum
// is computed here. This should make the code in the main
// loop easier to read and write.
char XBWriteAPI();

// This function will write the ptr array to the XB module.
// It will check to see that the module is ready to receive
// data. If not then we will return with a value of -1.
// We will also check to see if we are currently sending
// data to the XB module. If we are then we will return 
// a value of -1. A return value of -1 indicates that
// we can't write the buffer right now and control loop
// should try sometime later.
char XBWrite(char *ptr, char size);

// This function will read from the XB module and store the
// result in the array. Note that this function determines
// we are done with the reception based on the return character.
// Therefore, this function should only be called during AT mode.
// The interrupt will enable once we reach API mode which will
// render this function basically useless.
char XBRead(char *ptr);

// Initialize the dsPIC. We will init the clock, IO pins,
// push buttons, EEPROM, DMA for AtoD transfer, AtoD which
// is the IR sensors and battery monitor, Timers, Serial to
// the motor controller, Motor controller, IRDA, XB
// module, and the message flags.
void Init();

#endif

