/****************************************************************
* This header file is meant to contain all the constants and
* global variables for the code. The variables are declared and
* initialized in the Main.c file.
*
* Written by: Shane Avery
*****************************************************************/
#ifndef _MarsSatHeader
#define _MarsSatHeader

// Here are the const definitions for the LEDs.
extern const unsigned int LED0;		// dsPIC initialized.
extern const unsigned int LED1;
extern const unsigned int LED2;
extern const unsigned int LED3;
extern const unsigned int LED4;
extern const unsigned int LED5;		// General Purpose Error.
extern const unsigned int LED6;		// Low Battery Indicator (Red).
extern const unsigned int LEDAll;

// Global buffers for XBTX and XBRX.
extern unsigned char XBTX[17];
extern unsigned char XBRX[17];
extern unsigned char XBTXSize;
extern unsigned char XBRXSize;
extern unsigned char XBTXIndex;
extern unsigned char XBRXIndex;

// Global buffers for I2C EEPROM.
extern unsigned char I2CMSB,I2CLSB;
extern unsigned char I2CBuffer[64];
extern unsigned char I2CRW;
extern unsigned char I2CDone;
extern unsigned char I2CSize;

// Structs for the sending and receiving of data for the XBee module.
struct ReceivedData
{
	unsigned char Delimiter;
	unsigned char SizeMSB;
	unsigned char SizeLSB;
	unsigned char ID;
	unsigned char SourceAddMSB;
	unsigned char SourceAddLSB;
	unsigned char RSSI;
	unsigned char Options;
	unsigned char Data[8];
	unsigned char Checksum;
};

struct TransmitData
{
	unsigned char Delimiter;
	unsigned char SizeMSB;
	unsigned char SizeLSB;
	unsigned char ID;
	unsigned char FrameID;
	unsigned char DestAddMSB;
	unsigned char DestAddLSB;
	unsigned char Options;
	unsigned char Data[8];
	unsigned char Checksum;
};

struct StatusData
{
	unsigned char Delimiter;
	unsigned char SizeMSB;
	unsigned char SizeLSB;
	unsigned char ID;
	unsigned char FrameID;
	unsigned char Status;
	unsigned char Checksum;
};

// Declare a pointer variable structs.
extern struct StatusData *StatData;
extern struct ReceivedData RecData;
extern struct TransmitData TransData;

// Here are the structs to hold data about all robots and balls.
struct RobotStruct
{
	unsigned char TypeOfRobot;
	unsigned char CurrentLocation;
	unsigned char Status;
	unsigned char Confused;
	unsigned char Address;
};

struct BallStruct
{
	unsigned char BallLetter;
	unsigned char IRData;
	unsigned char Status;		// Unknown, There, NotThere
	unsigned char RelayStatus;
	unsigned char RelayData;
	unsigned char Robot;
};

extern struct RobotStruct Robot[4];
extern struct BallStruct Ball[8];


// Global buffers that define the messages.
extern char Button1Pressed;
extern char Button2Pressed;
extern char XBMessRec;
extern char Mutex;
extern char WaitForMutex;
extern char ReleaseMtx;
extern char GotStatus;
extern char FirstTimeMutex;
extern char FirstTimeMutexDone;
extern int EEPROMAddress;
extern char RecEEPROM;
extern char WriteEEPROMRX;

// Enums for readabiliy
// Define enum for the type of robot there could be.
enum {Seeker,Reader};

// Define enum for the status of a ball.
enum {Unknown,There,NotThere};

// Define enum for the XBee addresses of all the devices.
enum {EarthSat=1,MarsSat,Seeker1,Seeker2,Reader1,Reader2};

// Define enum for the robots as used in the arguements of messages.
enum {Seeker1Arg,Seeker2Arg,Reader1Arg,Reader2Arg,MarsSatArg};

// Define enum for the status of the robots.
enum {OK,NoLocalCOM,NoSatCOM,NoMove,Dead};

// Define enums for the types of messages.
enum {AreYouThereRobots=0x20,Talk,MRDamage,RelayDamage,Go,RelayGo,
	  BallFound,BallNOTFound,RobotConfusion,IRData,Stop,RelayStop,
	  Goto,RelayGoto,BallExists,RelayBallExists,Resume,RelayResume,
	  DumpEEPROM,RelayDumpEEPROM,YourDamage,MRLocation};
enum {ACK=1,MDamage,MLocation,MBallFound,MBallNotFound,MConfusion,
	  MBallData,MEEPROM};
enum {AreYouThere=9,ELocation,EStop,EBall,EResume,
	  EDamage,EEEPROM,EREEPROM};
enum {IAmHere=0x40,ICanTalk,RLocation,RLocationRelay,RBallFound,
	  RBallNotFound,RBallFoundRelay,RBallNotFoundRelay,RConfusion,
	  RConfusionRelay,RBallData,RBallDataRelay,REEPROM,REEPROMRelay};	  

#endif
