/*************************************************************
* This header file will provide the protoype function
* declarations of the HumanInterface functions.
*
* Written by: Shane Avery
**************************************************************/
#ifndef _HumanIntHeader
#define _HumanIntHeader

// This function will test the LEDs by turning each on for a
// short amount of time. Since the LEDs are used for debug it
// is useful to make sure that they are in fact working each
// time they are turned on. 
//
// NOTE: We intend to use this function one time after power
// up. Thus, we can re-use timer1 after this. In fact, the
// RS232 Terminal/IRDA uses timer1 so we in fact should not
// call this function after power up.
void LEDTest();

// Here is a function to test the EEPROM. We will first
// write a counter and then read it back. Then we will
// write all ones and read it back. Lastly we will
// write all zeros and read it back. We will output
// progress and results to the terminal.
void TestEEPROM();

// Here is the human interface function that will be
// called when button1 is pressed. This will provide
// text to the terminal that will help us develop the
// code for the robot.
void HumanInt();

#endif
