#ifndef  EZVGA_H
#define  EZVGA_H

// The dimension of the VGA
#define V_WIDTH        320
#define V_HEIGHT       240

// Primary colors used
#define V_BLUE         0x10
#define V_GREEN        0x04
#define V_RED          0x01
#define V_MAXINTENSITY 3

#define V_AREACLEAR    0x41
#define V_SETBCKGND    0x42
#define V_SCRNCLEAR    0x43
#define V_CREATCHAR    0x44
#define V_FLOATCHAR    0x46
#define V_DRAWALINE    0x4C
#define V_PLACECHAR    0x50
#define V_READPIXEL    0x52
#define V_WRITPIXEL    0x57

// Enumerate the Oscillators
enum e_Color {
    EC_Blue = 0,
    EC_Green,
    EC_Red
};

// Parameter
extern unsigned int ezVGABufferSize;
extern char ezVGABuffer[10];

char ClearArea(char color, int x1, char y1, int x2, char y2);
char SetBackground(char color);
char ClearScreen(char color);
char CreateCharacter(char idx, char row0, char row1, char row2, char row3,
                     char row4, char row5, char row6, char row7);
char FloatingChar(char idx, char mode, char color, int x, char y);
char DrawLine(char color, int x1, char y1, int x2, char y2);
char PlaceCharacter(char idx, char mode, char size, char color, int x, char y);
char ReadPixel(int x, char y);
char WritePixel(char color, int x, char y);

// Issue command and misc functions
char MixColor(char Blue, char Green, char Red);
char ezVGAIssueCMD();

#endif
