#ifndef  SOUNDGIN_H
#define  SOUNDGIN_H

// Command to sound card
#define	 S_CMD	0x1B

// Sound card commands
#define  S_R1B        0x00  // Read One Byte
#define  S_W1B        0x01	// Write One Byte
#define  S_W2B        0x02 	// Write Two Bytes
#define  S_W3B        0x03 	// Write Three Bytes
#define  S_W1BM       0x04 	// Write One Byte With Mask
#define	 S_CMAB       0x06 	// Clear Mixers A, B
#define	 S_RTAB       0x07 	// Ramp To Targets A, B
#define	 S_SVN        0x08 	// Set Voice Note
#define	 S_SVF        0x09 	// Set Voice Frequency
#define	 S_SVD		  0x0A 	// Set Voice Delay
#define	 S_SVDEF   	  0x0B 	// Set Voice Default Parameters
#define	 S_QON		  0x0E 	// Turn Q On
#define	 S_QOFF		  0x0F 	// Turn Q Off
#define	 S_CMOA		  0x46 	// Clear Mixer & Oscillators A
#define	 S_CMOB		  0x66 	// Clear Mixer & Oscillators B
#define	 S_RTA		  0x47 	// Ramp to Targets A
#define	 S_RTB		  0x67	// Ramp to Targets B
#define	 S_LNOA1	  0x48 	// Loads a Musical Note into Oscillator A1
#define	 S_LNOB1	  0x68 	// Loads a Musical Note into Oscillator B1
#define	 S_LNOA2	  0x49 	// Loads a Musical Note into Oscillator A2
#define	 S_LNOB2	  0x69 	// Loads a Musical Note into Oscillator B2
#define	 S_LNOA3      0x4A 	// Loads a Musical Note into Oscillator A3
#define	 S_LNOB3	  0x6A 	// Loads a Musical Note into Oscillator B3
#define	 S_LSMA		  0x4B 	// Loads a Sound into Mixer A
#define	 S_LSMB		  0x6B	// Loads a Sound into Mixer B
#define	 S_LFOA1	  0x4C 	// Loads a Frequency into Oscillator A1
#define	 S_LFOB1	  0x6C 	// Loads a Frequency into Oscillator B1
#define	 S_LFOA2	  0x4D 	// Loads a Frequency into Oscillator A2
#define	 S_LFOB2	  0x6D 	// Loads a Frequency into Oscillator B2
#define	 S_LFOA3	  0x4E 	// Loads a Frequency into Oscillator A3
#define	 S_LFOB3	  0x6E 	// Loads a Frequency into Oscillator B3
#define	 S_PCOA1	  0x50 	// Plays the Current Oscillator A1 settings
#define	 S_PCOB1	  0x70 	// Plays the Current Oscillator B1 settings
#define	 S_PCOA2	  0x51 	// Plays the Current Oscillator A2 settings
#define	 S_PCOB2	  0x71 	// Plays the Current Oscillator B2 settings
#define	 S_PCOA3	  0x52 	// Plays the Current Oscillator A3 settings
#define	 S_PCOB3	  0x72 	// Plays the Current Oscillator B3 settings
#define	 S_PCMA		  0x53 	// Plays the Current Mixer A settings
#define	 S_PCMB		  0x73 	// Plays the Current Mixer B settings
#define	 S_ROA1		  0x54 	// Releases Oscillator A1
#define  S_ROB1		  0x74 	// Releases Oscillator B1
#define	 S_ROA2		  0x55 	// Releases Oscillator A2
#define	 S_ROB2		  0x75 	// Releases Oscillator B2
#define	 S_ROA3		  0x56 	// Releases Oscillator A3
#define	 S_ROB3		  0x76 	// Releases Oscillator B3
#define	 S_RMA		  0x57 	// Releases Mixer A
#define	 S_RMB		  0x77 	// Releases Mixer B
#define	 S_LPNOA1	  0x58 	// Loads & Plays a Musical Note in Oscillator A1
#define	 S_LPNOB1	  0x78 	// Loads & Plays a Musical Note in Oscillator B1
#define	 S_LPNOA2	  0x59 	// Loads & Plays a Musical Note in Oscillator A2
#define	 S_LPNOB2	  0x79 	// Loads & Plays a Musical Note in Oscillator B2
#define	 S_LPNOA3	  0x5A 	// Loads & Plays a Musical Note in Oscillator A3
#define	 S_LPNOB3	  0x7A 	// Loads & Plays a Musical Note in Oscillator B3
#define	 S_RVPA		  0x5B 	// Reset to Voice Parameters A
#define	 S_RVPB		  0x7B	// Reset to Voice Parameters B
#define	 S_LPFOA1	  0x5C 	// Loads & Plays a Frequency in Oscillator A1
#define	 S_LPFOB1	  0x7C 	// Loads & Plays a Frequency in Oscillator B1
#define	 S_LPFOA2	  0x5D 	// Loads & Plays a Frequency in Oscillator A2
#define	 S_LPFOB2	  0x7D 	// Loads & Plays a Frequency in Oscillator B2
#define	 S_LPFOA3	  0x5E 	// Loads & Plays a Frequency in Oscillator A3
#define	 S_LPFOB3	  0x7E 	// Loads & Plays a Frequency in Oscillator B3

// Mixer A Register Map
#define S_MIXCNT0A    0x00  // Mix Control 0
#define S_MIXCNT1A    0x01  // Mix Control 1
#define S_OSCDISTA1   0x02  // Osc A1 Distortion
#define S_OSCDISTA2   0x03  // Osc A2 Distortion
#define S_OSCDISTA3   0x04  // Osc A3 Distortion
#define S_OSCPWMA1    0x05  // Osc A1 PWM
#define S_OSCPWMA2    0x06  // Osc A2 PWM
#define S_OSCPWMA3    0x07  // Osc A3 PWM
#define S_AMP_MA      0x08  // Amplitude
#define S_AMPTGT_MA   0x09  // Amplitude Target
#define S_AMPTRANL_MA 0x0A  // Amplitude Transition Low
#define S_AMPTRANH_MA 0x0B  // Amplitude Transition High
#define S_ENVCNT_MA   0x0C  // Envelope Control
#define S_ENVATT_MA   0x0D  // Envelope Attack
#define S_ENVDEC_MA   0x0E  // Envelope Decay
#define S_ENVRES_MA   0x0F  // Envelope Release

// Oscillator A1 Register Map
#define S_OSCCTRA1    0x10  // Osc Control
#define S_FREQFINEA1  0x11  // Frequency Fine
#define S_FREQLOWA1   0x12  // Frequency Low
#define S_FREQHIGHA1  0x13  // Frequency High
#define S_FREQTGTLA1  0x14  // Frequency Target Low
#define S_FREQTGTHA1  0x15  // Frequency Target High
#define S_FREQTRANLA1 0x16  // Frequency Transition Low
#define S_FREQTRANHA1 0x17  // Frequency Transition High
#define S_AMP_A1      0x18  // Amplitude
#define S_AMPTGT_A1   0x19  // Amplitude Target
#define S_AMPTRANL_A1 0x1A  // Amplitude Transition Low
#define S_AMPTRANH_A1 0x1B  // Amplitude Transition High
#define S_ENVCNT_A1   0x1C  // Envelope Control
#define S_ENVATT_A1   0x1D  // Envelope Attack
#define S_ENVDEC_A1   0x1E  // Envelope Decay
#define S_ENVRES_A1   0x1F  // Envelope Release

// Oscillator A2 Register Map
#define S_OSCCTRA2    0x20  // Osc Control
#define S_FREQFINEA2  0x21  // Frequency Fine
#define S_FREQLOWA2   0x22  // Frequency Low
#define S_FREQHIGHA2  0x23  // Frequency High
#define S_FREQTGTLA2  0x24  // Frequency Target Low
#define S_FREQTGTHA2  0x25  // Frequency Target High
#define S_FREQTRANLA2 0x26  // Frequency Transition Low
#define S_FREQTRANHA2 0x27  // Frequency Transition High
#define S_AMP_A2      0x28  // Amplitude
#define S_AMPTGT_A2   0x29  // Amplitude Target
#define S_AMPTRANL_A2 0x2A  // Amplitude Transition Low
#define S_AMPTRANH_A2 0x2B  // Amplitude Transition High
#define S_ENVCNT_A2   0x2C  // Envelope Control
#define S_ENVATT_A2   0x2D  // Envelope Attack
#define S_ENVDEC_A2   0x2E  // Envelope Decay
#define S_ENVRES_A2   0x2F  // Envelope Release

// Oscillator A3 Register Map
#define S_OSCCTRA3    0x30  // Osc Control
#define S_FREQFINEA3  0x31  // Frequency Fine
#define S_FREQLOWA3   0x32  // Frequency Low
#define S_FREQHIGHA3  0x33  // Frequency High
#define S_FREQTGTLA3  0x34  // Frequency Target Low
#define S_FREQTGTHA3  0x35  // Frequency Target High
#define S_FREQTRANLA3 0x36  // Frequency Transition Low
#define S_FREQTRANHA3 0x37  // Frequency Transition High
#define S_AMP_A3      0x38  // Amplitude
#define S_AMPTGT_A3   0x39  // Amplitude Target
#define S_AMPTRANL_A3 0x3A  // Amplitude Transition Low
#define S_AMPTRANH_A3 0x3B  // Amplitude Transition High
#define S_ENVCNT_A3   0x3C  // Envelope Control
#define S_ENVATT_A3   0x3D  // Envelope Attack
#define S_ENVDEC_A3   0x3E  // Envelope Decay
#define S_ENVRES_A3   0x3F  // Envelope Release

// Mixer B Register Map
#define S_MIXCNT0B    0x40  // Mix Control 0
#define S_MIXCNT1B    0x41  // Mix Control 1
#define S_OSCDISTB1   0x42  // Osc A1 Distortion
#define S_OSCDISTB2   0x43  // Osc A2 Distortion
#define S_OSCDISTB3   0x44  // Osc A3 Distortion
#define S_OSCPWMB1    0x45  // Osc A1 PWM
#define S_OSCPWMB2    0x46  // Osc A2 PWM
#define S_OSCPWMB3    0x47  // Osc A3 PWM
#define S_AMP_MB      0x48  // Amplitude
#define S_AMPTGT_MB   0x49  // Amplitude Target
#define S_AMPTRANL_MB 0x4A  // Amplitude Transition Low
#define S_AMPTRANH_MB 0x4B  // Amplitude Transition High
#define S_ENVCNT_MB   0x4C  // Envelope Control
#define S_ENVATT_MB   0x4D  // Envelope Attack
#define S_ENVDEC_MB   0x4E  // Envelope Decay
#define S_ENVRES_MB   0x4F  // Envelope Release

// Oscillator B1 Register Map
#define S_OSCCTRB1    0x50  // Osc Control
#define S_FREQFINEB1  0x51  // Frequency Fine
#define S_FREQLOWB1   0x52  // Frequency Low
#define S_FREQHIGHB1  0x53  // Frequency High
#define S_FREQTGTLB1  0x54  // Frequency Target Low
#define S_FREQTGTHB1  0x55  // Frequency Target High
#define S_FREQTRANLB1 0x56  // Frequency Transition Low
#define S_FREQTRANHB1 0x57  // Frequency Transition High
#define S_AMP_B1      0x58  // Amplitude
#define S_AMPTGT_B1   0x59  // Amplitude Target
#define S_AMPTRANL_B1 0x5A  // Amplitude Transition Low
#define S_AMPTRANH_B1 0x5B  // Amplitude Transition High
#define S_ENVCNT_B1   0x5C  // Envelope Control
#define S_ENVATT_B1   0x5D  // Envelope Attack
#define S_ENVDEC_B1   0x5E  // Envelope Decay
#define S_ENVRES_B1   0x5F  // Envelope Release

// Oscillator B2 Register Map
#define S_OSCCTRB2    0x60  // Osc Control
#define S_FREQFINEB2  0x61  // Frequency Fine
#define S_FREQLOWB2   0x62  // Frequency Low
#define S_FREQHIGHB2  0x63  // Frequency High
#define S_FREQTGTLB2  0x64  // Frequency Target Low
#define S_FREQTGTHB2  0x65  // Frequency Target High
#define S_FREQTRANLB2 0x66  // Frequency Transition Low
#define S_FREQTRANHB2 0x67  // Frequency Transition High
#define S_AMP_B2      0x68  // Amplitude
#define S_AMPTGT_B2   0x69  // Amplitude Target
#define S_AMPTRANL_B2 0x6A  // Amplitude Transition Low
#define S_AMPTRANH_B2 0x6B  // Amplitude Transition High
#define S_ENVCNT_B2   0x6C  // Envelope Control
#define S_ENVATT_B2   0x6D  // Envelope Attack
#define S_ENVDEC_B2   0x6E  // Envelope Decay
#define S_ENVRES_B2   0x6F  // Envelope Release

// Oscillator B3 Register Map
#define S_OSCCTRB3    0x70  // Osc Control
#define S_FREQFINEB3  0x71  // Frequency Fine
#define S_FREQLOWB3   0x72  // Frequency Low
#define S_FREQHIGHB3  0x73  // Frequency High
#define S_FREQTGTLB3  0x74  // Frequency Target Low
#define S_FREQTGTHB3  0x75  // Frequency Target High
#define S_FREQTRANLB3 0x76  // Frequency Transition Low
#define S_FREQTRANHB3 0x77  // Frequency Transition High
#define S_AMP_B3      0x78  // Amplitude
#define S_AMPTGT_B3   0x79  // Amplitude Target
#define S_AMPTRANL_B3 0x7A  // Amplitude Transition Low
#define S_AMPTRANH_B3 0x7B  // Amplitude Transition High
#define S_ENVCNT_B3   0x7C  // Envelope Control
#define S_ENVATT_B3   0x7D  // Envelope Attack
#define S_ENVDEC_B3   0x7E  // Envelope Decay
#define S_ENVRES_B3   0x7F  // Envelope Release

// Chip Control
#define S_MISCCNTR    0x80  // Misc Control
#define S_SPDCNTR     0x81  // Speech Control
#define S_SPDFREQL    0x82  // Speech Frequency Low
#define S_SPDFREQH    0x83  // Speech Frequency High
#define S_TRANSPD     0x84  // Transition Speed
#define S_INTERNCLK   0x85  // Internal Clock
#define S_PITCHBENDA  0x86  // Pitch Bend A
#define S_PITCHBENDB  0x87  // Pitch Bend B
#define S_AMPLITUDE   0x88  // Amplitude
#define S_PORT        0x89  // Port
#define S_OSCA1OUT    0x8A  // Osc A1 Output
#define S_OSCA2OUT    0x8B  // Osc A2 Output
#define S_OSCA3OUT    0x8C  // Osc A3 Output
#define S_OSCB1OUT    0x8D  // Osc B1 Output
#define S_OSCB2OUT    0x8E  // Osc B2 Output
#define S_OSCB3OUT    0x8F  // Osc B3 Output

// Music Notes Definition
#define  C0           0x00
#define	 C0s          0x01
#define	 D0           0x02
#define	 D0s          0x03
#define	 E0	          0x04
#define	 F0	          0x05
#define	 F0s          0x06
#define	 G0	          0x07
#define	 G0s	      0x08
#define	 A0		      0x09
#define	 A0s	      0x0A
#define	 B0		      0x0B

#define	 C1		      0x10
#define	 C1s	      0x11
#define	 D1		      0x12
#define	 D1s	      0x13
#define	 E1		      0x14
#define	 F1		      0x15
#define	 F1s	      0x16
#define	 G1		      0x17
#define	 G1s	      0x18
#define	 A1		      0x19
#define	 A1s	      0x1A
#define	 B1		      0x1B

#define	 C2		      0x20
#define	 C2s	      0x21
#define	 D2		      0x22
#define	 D2s	      0x23
#define	 E2		      0x24
#define	 F2		      0x25
#define	 F2s	      0x26
#define	 G2		      0x27
#define	 G2s	      0x28
#define	 A2		      0x29
#define	 A2s	      0x2A
#define  B2		      0x2B

#define	 C3		      0x30
#define	 C3s	      0x31
#define	 D3		      0x32
#define	 D3s	      0x33
#define	 E3		      0x34
#define	 F3		      0x35
#define	 F3s	      0x36
#define	 G3		      0x37
#define	 G3s	      0x38
#define	 A3		      0x39
#define	 A3s	      0x3A
#define	 B3		      0x3B

#define	 C4		      0x40	// Middle C
#define	 C4s	      0x41
#define	 D4		      0x42
#define	 D4s	      0x43
#define	 E4		      0x44
#define	 F4		      0x45
#define	 F4s	      0x46
#define	 G4		      0x47
#define	 G4s	      0x48
#define	 A4		      0x49
#define	 A4s	      0x4A
#define	 B4		      0x4B

#define	 C5		      0x50
#define	 C5s	      0x51
#define	 D5		      0x52
#define	 D5s	      0x53
#define	 E5		      0x54
#define	 F5		      0x55
#define	 F5s	      0x56
#define	 G5		      0x57
#define	 G5s	      0x58
#define	 A5		      0x59
#define	 A5s	      0x5A
#define	 B5		      0x5B

#define	 C6		      0x60
#define	 C6s	      0x61
#define	 D6		      0x62
#define	 D6s	      0x63
#define	 E6		      0x64
#define	 F6		      0x65
#define	 F6s	      0x66
#define	 G6		      0x67
#define	 G6s	      0x68
#define	 A6		      0x69
#define	 A6s	      0x6A
#define	 B6		      0x6B

#define	 C7		      0x70
#define	 C7s	      0x71
#define	 D7		      0x72
#define	 D7s	      0x73
#define	 E7		      0x74
#define	 F7		      0x75
#define	 F7s	      0x76
#define	 G7		      0x77
#define	 G7s	      0x78
#define	 A7		      0x79
#define	 A7s	      0x7A
#define	 B7		      0x7B

// Allophones Definition
#define	 A_A          0xC0	// Hat, Fast, Fan
#define	 A_AA         0xC1	// Father, Fall
#define	 A_AE		  0xC2	// Gate, Ate, Ray
#define	 A_AIR		  0xC3	// Hair, Stair, Repair
#define	 A_AU		  0xC4	// Hot, Clock, Fox
#define	 A_BE		  0xC5	// Bear, Bird, Beed
#define	 A_BO		  0xC6	// Bone, Book Brown
#define	 A_EB		  0xC7	// Cab, Crib, Web
#define	 A_OB		  0xC8	// Bob, Sub, Tub
#define	 A_CH		  0xC9	// Church, Feature, March
#define	 A_DE		  0xCA	// Deep, Date, Divide
#define	 A_DO		  0xCB	// Do, Dust, Dog
#define	 A_ED		  0xCC	// Could, Bird
#define	 A_OD		  0xCD	// Bud, Food
#define	 A_E		  0xCE	// Met, Check, Red
#define	 A_EE		  0xCF	// See, Even, Feed
#define	 A_ER		  0xD0	// Fir, Bird, Burn
#define	 A_F		  0xD1	// Food, Effort, Off
#define	 A_GE		  0xD2	// Get, Gate, Guest
#define	 A_GO		  0xD3	// Got, Glue, Goo
#define	 A_HE		  0xD4	// Help, Hand, Hair
#define	 A_HO		  0xD5	// Hoe, Hot, Hug
#define	 A_I		  0xD6	// Sit, Fix, Pin
#define	 A_IE		  0xD7	// Mice, Fight, White
#define	 A_J		  0xD8	// Dodge, Jet, Savage
#define	 A_KE		  0xD9	// Can't, Clown, Key
#define	 A_KO		  0xDA	// Comb, Quick, Fox
#define	 A_EK		  0xDB	// Speak, Task
#define	 A_OK		  0xDC	// Book, Took, October
#define	 A_LE		  0xDD	// Lake, Alarm, Lapel
#define	 A_LO		  0xDE	// Clock, Plus, Hello
#define	 A_M		  0xDF	// Milk, Famous, Broom
#define	 A_NE		  0xE0	// Nip, Danger, Thin
#define	 A_NO		  0xE1	// No, Snow, On
#define	 A_NGE		  0xE2	// Think, Ping
#define	 A_NGO		  0xE3	// Hung, Song
#define	 A_OE		  0xE4	// Go, Hello, Snow
#define	 A_OI		  0xE5	// Boy, Toy, Voice
#define	 A_OO		  0xE6	// Book, Could, Should
#define	 A_OU		  0xE7	// Our, Ouch, Owl
#define	 A_OR		  0xE8	// Corn, Four, Your
#define	 A_PE		  0xE9	// People, Computer
#define	 A_PO		  0xEA	// Pow, Copy
#define	 A_R		  0xEB	// Ray, Brain, Over
#define	 A_SE		  0xEC	// See, Vest, Plus
#define	 A_SO		  0xED	// So, Sweat
#define	 A_SH		  0xEE	// Ship, Fiction, Leash
#define	 A_T		  0xEF	// Part, Little, Sit
#define	 A_TH		  0xF0	// Thin, month
#define	 A_THH		  0xF1	// There, That, This
#define	 A_TS		  0xF2	// Parts, Costs, Robots
#define	 A_U		  0xF3	// Luck, Jump, Plus
#define	 A_UE		  0xF4	// Food, June
#define	 A_V		  0xF5	// Vest, Even, Twelve
#define	 A_W		  0xF6	// Wool, Sweat
#define	 A_Y		  0xF7	// Yes, Yarn, Million
#define	 A_Z		  0xF8	// Zoo, Zap
#define	 A_ZH		  0xF9	// Azure, Treasure
#define	 PA0		  0xFA	// PA0
#define	 PA1		  0xFB	// PA1
#define	 PA2		  0xFC	// PA2
#define	 FD0		  0xFD	// FD0
#define	 FD1		  0xFE	// FD1
#define	 FD2		  0xFF	// FD2

// Enumerate the Oscillators
enum e_Oscillator {
    EO_A1 = 0,
    EO_A2,
    EO_A3,
    EO_B1,
    EO_B2,
    EO_B3
};

// Parameter
extern char SGBlocking;
extern unsigned int SoundBufferSize;
extern char SoundBuffer[6];

// temp
extern int SerialOut;  // to be replaced by the register address in another h file
extern int SerialComplete;

// Sound card interface prototypes
char ReadOneByte(unsigned char Reg);
char WriteOneByte(unsigned char Reg, unsigned char Byte);
char WriteTwoByte(unsigned char Reg, unsigned char Byte1, unsigned Byte2);
char WriteThreeByte(unsigned char Reg, unsigned char Byte1,
                    unsigned char Byte2, unsigned char Byte3);
char WriteOneByteWMask(unsigned char Reg, unsigned Byte, unsigned char Mask);
char ClearMixerAB();
char RampToTargets(char A, char B);
char SetVoiceNote(unsigned char Note);
char SetVoiceFreq(unsigned int Freq);
char SetVoiceDelay(unsigned char Delay);
char SetVoiceDefault();
char SetQOn();
char SetQOff();
char ClearMixerOscillators(char A);
char LoadlNote(char Osc, unsigned char Note);
char LoadSound(char A, unsigned char Sound);
char LoadFreq(char Osc, unsigned int Freq);
char PlayCurrentOscillator(char Osc);
char PlayCurrentMixer(char A);
char ReleaseOscillator(char Osc);
char ReleaseMixer(char A);
char LoadPlayNote(char Osc, unsigned char Note);
char LoadPlayFreq(char Osc, unsigned int Freq);
char ResetVoiceParameter(char A);

// Communications subroutien prototypes
char IssueCommand(unsigned char Para, unsigned char Cmd,
                 unsigned char Arg1,
                 unsigned char Arg2,
                 unsigned char Arg3,
                 unsigned char Arg4);

#endif
